/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.connector.thrift.api.PrestoThriftBlock;
import com.facebook.presto.connector.thrift.api.datatypes.PrestoThriftBigint;
import com.facebook.presto.connector.thrift.api.datatypes.PrestoThriftColumnData;
import com.facebook.presto.connector.thrift.api.datatypes.PrestoThriftTypeUtils;
import com.facebook.presto.spi.block.AbstractArrayBlock;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LongArrayBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftBigintArray
implements PrestoThriftColumnData {
    private final boolean[] nulls;
    private final int[] sizes;
    private final PrestoThriftBigint values;

    @ThriftConstructor
    public PrestoThriftBigintArray(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="sizes") @Nullable int[] sizes, @ThriftField(name="values") @Nullable PrestoThriftBigint values) {
        Preconditions.checkArgument((boolean)PrestoThriftTypeUtils.sameSizeIfPresent(nulls, sizes), (Object)"nulls and values must be of the same size");
        Preconditions.checkArgument((PrestoThriftTypeUtils.totalSize(nulls, sizes) == PrestoThriftBigintArray.numberOfValues(values) ? 1 : 0) != 0, (Object)"total number of values doesn't match expected size");
        this.nulls = nulls;
        this.sizes = sizes;
        this.values = values;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getSizes() {
        return this.sizes;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftBigint getValues() {
        return this.values;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((desiredType.getTypeParameters().size() == 1 && BigintType.BIGINT.equals(desiredType.getTypeParameters().get(0)) ? 1 : 0) != 0, (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return ArrayBlock.fromElementBlock((int)numberOfRecords, Optional.of(this.nulls == null ? new boolean[numberOfRecords] : this.nulls), (int[])PrestoThriftTypeUtils.calculateOffsets(this.sizes, this.nulls, numberOfRecords), (Block)(this.values != null ? this.values.toBlock((Type)BigintType.BIGINT) : new LongArrayBlock(0, Optional.empty(), new long[0])));
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.sizes != null) {
            return this.sizes.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftBigintArray other = (PrestoThriftBigintArray)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.sizes, other.sizes) && Objects.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.sizes), this.values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static PrestoThriftBlock fromBlock(Block block) {
        Preconditions.checkArgument((boolean)(block instanceof AbstractArrayBlock), (Object)"block is not of an array type");
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        int positions = arrayBlock.getPositionCount();
        if (positions == 0) {
            return PrestoThriftBlock.bigintArrayData(new PrestoThriftBigintArray(null, null, null));
        }
        boolean[] nulls = null;
        int[] sizes = null;
        for (int position = 0; position < positions; ++position) {
            if (arrayBlock.isNull(position)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (sizes == null) {
                sizes = new int[positions];
            }
            sizes[position] = (Integer)arrayBlock.apply((valuesBlock, startPosition, length) -> length, position);
        }
        PrestoThriftBigint values = ((PrestoThriftBlock)arrayBlock.apply((valuesBlock, startPosition, length) -> PrestoThriftBigint.fromBlock(valuesBlock), 0)).getBigintData();
        Preconditions.checkState((values != null ? 1 : 0) != 0, (Object)"values must be present");
        Preconditions.checkState((PrestoThriftTypeUtils.totalSize(nulls, sizes) == values.numberOfRecords() ? 1 : 0) != 0, (Object)"unexpected number of values");
        return PrestoThriftBlock.bigintArrayData(new PrestoThriftBigintArray(nulls, sizes, values));
    }

    private static int numberOfValues(PrestoThriftBigint values) {
        return values != null ? values.numberOfRecords() : 0;
    }
}

