/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.io;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.index.Indexer;
import com.facebook.presto.accumulo.metadata.AccumuloTable;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.model.Field;
import com.facebook.presto.accumulo.model.Row;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public class AccumuloPageSink
implements ConnectorPageSink {
    public static final Text ROW_ID_COLUMN = new Text("___ROW___");
    private final AccumuloRowSerializer serializer;
    private final BatchWriter writer;
    private final Optional<Indexer> indexer;
    private final List<AccumuloColumnHandle> columns;
    private final int rowIdOrdinal;
    private long numRows;

    public AccumuloPageSink(Connector connector, AccumuloTable table, String username) {
        Objects.requireNonNull(table, "table is null");
        this.columns = table.getColumns();
        Optional<Integer> ordinal = this.columns.stream().filter(columnHandle -> columnHandle.getName().equals(table.getRowId())).map(AccumuloColumnHandle::getOrdinal).findAny();
        if (!ordinal.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Row ID ordinal not found");
        }
        this.rowIdOrdinal = ordinal.get();
        this.serializer = table.getSerializerInstance();
        try {
            BatchWriterConfig conf = new BatchWriterConfig();
            this.writer = connector.createBatchWriter(table.getFullTableName(), conf);
            this.indexer = table.isIndexed() ? Optional.of(new Indexer(connector, connector.securityOperations().getUserAuthorizations(username), table, conf)) : Optional.empty();
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Accumulo error when creating BatchWriter and/or Indexer", e);
        }
        catch (TableNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Accumulo error when creating BatchWriter and/or Indexer, table does not exist", (Throwable)e);
        }
    }

    public static Mutation toMutation(Row row, int rowIdOrdinal, List<AccumuloColumnHandle> columns, AccumuloRowSerializer serializer) {
        Text value = new Text();
        Field rowField = row.getField(rowIdOrdinal);
        if (rowField.isNull()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Column mapped as the Accumulo row ID cannot be null");
        }
        AccumuloPageSink.setText(rowField, value, serializer);
        Mutation mutation = new Mutation(value);
        mutation.put(ROW_ID_COLUMN, ROW_ID_COLUMN, new Value(value.copyBytes()));
        for (AccumuloColumnHandle columnHandle : columns) {
            if (columnHandle.getOrdinal() == rowIdOrdinal || row.getField(columnHandle.getOrdinal()).isNull()) continue;
            AccumuloPageSink.setText(row.getField(columnHandle.getOrdinal()), value, serializer);
            mutation.put((CharSequence)columnHandle.getFamily().get(), (CharSequence)columnHandle.getQualifier().get(), new Value(value.copyBytes()));
        }
        return mutation;
    }

    private static void setText(Field field, Text value, AccumuloRowSerializer serializer) {
        Type type = field.getType();
        if (Types.isArrayType(type)) {
            serializer.setArray(value, type, field.getArray());
        } else if (Types.isMapType(type)) {
            serializer.setMap(value, type, field.getMap());
        } else if (type.equals(BigintType.BIGINT)) {
            serializer.setLong(value, field.getLong());
        } else if (type.equals(BooleanType.BOOLEAN)) {
            serializer.setBoolean(value, field.getBoolean());
        } else if (type.equals(DateType.DATE)) {
            serializer.setDate(value, field.getDate());
        } else if (type.equals(DoubleType.DOUBLE)) {
            serializer.setDouble(value, field.getDouble());
        } else if (type.equals(IntegerType.INTEGER)) {
            serializer.setInt(value, field.getInt());
        } else if (type.equals(RealType.REAL)) {
            serializer.setFloat(value, field.getFloat());
        } else if (type.equals(SmallintType.SMALLINT)) {
            serializer.setShort(value, field.getShort());
        } else if (type.equals(TimeType.TIME)) {
            serializer.setTime(value, field.getTime());
        } else if (type.equals(TinyintType.TINYINT)) {
            serializer.setByte(value, field.getByte());
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            serializer.setTimestamp(value, field.getTimestamp());
        } else if (type.equals(VarbinaryType.VARBINARY)) {
            serializer.setVarbinary(value, field.getVarbinary());
        } else if (type instanceof VarcharType) {
            serializer.setVarchar(value, field.getVarchar());
        } else {
            throw new UnsupportedOperationException("Unsupported type " + type);
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Row row = new Row();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Type type = this.columns.get(channel).getType();
                row.addField(TypeUtils.readNativeValue((Type)type, (Block)page.getBlock(channel), (int)position), type);
            }
            try {
                Mutation mutation = AccumuloPageSink.toMutation(row, this.rowIdOrdinal, this.columns, this.serializer);
                this.writer.addMutation(mutation);
                if (this.indexer.isPresent()) {
                    this.indexer.get().index(mutation);
                }
                ++this.numRows;
            }
            catch (MutationsRejectedException e) {
                throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Mutation rejected by server", (Throwable)e);
            }
            if (this.numRows % 100000L != 0L) continue;
            this.flush();
        }
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try {
            this.writer.flush();
            this.writer.close();
            if (this.indexer.isPresent()) {
                this.indexer.get().close();
            }
        }
        catch (MutationsRejectedException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Mutation rejected by server on flush", (Throwable)e);
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        MoreFutures.getFutureValue(this.finish());
    }

    private void flush() {
        try {
            if (this.indexer.isPresent()) {
                this.indexer.get().flush();
            }
            this.writer.flush();
        }
        catch (MutationsRejectedException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Mutation rejected by server on flush", (Throwable)e);
        }
    }
}

