/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.io;

import com.facebook.presto.accumulo.AccumuloClient;
import com.facebook.presto.accumulo.conf.AccumuloConfig;
import com.facebook.presto.accumulo.io.AccumuloPageSink;
import com.facebook.presto.accumulo.model.AccumuloTableHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkProperties;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.accumulo.core.client.Connector;

public class AccumuloPageSinkProvider
implements ConnectorPageSinkProvider {
    private final AccumuloClient client;
    private final Connector connector;
    private final String username;

    @Inject
    public AccumuloPageSinkProvider(Connector connector, AccumuloConfig config, AccumuloClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.username = Objects.requireNonNull(config, "config is null").getUsername();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkProperties pageSinkProperties) {
        Preconditions.checkArgument((!pageSinkProperties.isPartitionCommitRequired() ? 1 : 0) != 0, (Object)"Accumulo connector does not support partition commit");
        AccumuloTableHandle tableHandle = (AccumuloTableHandle)outputTableHandle;
        return new AccumuloPageSink(this.connector, this.client.getTable(tableHandle.toSchemaTableName()), this.username);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkProperties pageSinkProperties) {
        return this.createPageSink(transactionHandle, session, (ConnectorOutputTableHandle)insertTableHandle, pageSinkProperties);
    }
}

