/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.metadata;

import com.facebook.presto.accumulo.index.Indexer;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AccumuloTable {
    private final boolean external;
    private final Integer rowIdOrdinal;
    private final String schema;
    private final String serializerClassName;
    private final Optional<String> scanAuthorizations;
    private final List<ColumnMetadata> columnsMetadata;
    private final boolean indexed;
    private final List<AccumuloColumnHandle> columns;
    private final String rowId;
    private final String table;
    private final SchemaTableName schemaTableName;

    @JsonCreator
    public AccumuloTable(@JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="columns") List<AccumuloColumnHandle> columns, @JsonProperty(value="rowId") String rowId, @JsonProperty(value="external") boolean external, @JsonProperty(value="serializerClassName") String serializerClassName, @JsonProperty(value="scanAuthorizations") Optional<String> scanAuthorizations) {
        this.external = external;
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns are null"));
        this.serializerClassName = Objects.requireNonNull(serializerClassName, "serializerClassName is null");
        this.scanAuthorizations = scanAuthorizations;
        boolean indexed = false;
        Optional<Object> rowIdOrdinal = Optional.empty();
        ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
        for (AccumuloColumnHandle column : this.columns) {
            columnMetadataBuilder.add((Object)column.getColumnMetadata());
            indexed |= column.isIndexed();
            if (!column.getName().equals(this.rowId)) continue;
            rowIdOrdinal = Optional.of(column.getOrdinal());
        }
        if (!rowIdOrdinal.isPresent()) {
            throw new IllegalArgumentException("rowIdOrdinal is null, enable to locate rowId in given column list");
        }
        this.rowIdOrdinal = (Integer)rowIdOrdinal.get();
        this.indexed = indexed;
        this.columnsMetadata = columnMetadataBuilder.build();
        this.schemaTableName = new SchemaTableName(this.schema, this.table);
    }

    @JsonProperty
    public String getRowId() {
        return this.rowId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonIgnore
    public String getIndexTableName() {
        return Indexer.getIndexTableName(this.schema, this.table);
    }

    @JsonIgnore
    public String getMetricsTableName() {
        return Indexer.getMetricsTableName(this.schema, this.table);
    }

    @JsonIgnore
    public String getFullTableName() {
        return AccumuloTable.getFullTableName(this.schema, this.table);
    }

    @JsonProperty
    public List<AccumuloColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getScanAuthorizations() {
        return this.scanAuthorizations;
    }

    @JsonProperty
    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    @JsonIgnore
    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }

    @JsonProperty
    public boolean isExternal() {
        return this.external;
    }

    @JsonIgnore
    public boolean isIndexed() {
        return this.indexed;
    }

    @JsonIgnore
    public int getRowIdOrdinal() {
        return this.rowIdOrdinal;
    }

    @JsonIgnore
    public AccumuloRowSerializer getSerializerInstance() {
        try {
            return (AccumuloRowSerializer)Class.forName(this.serializerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Configured serializer class not found", (Throwable)e);
        }
    }

    @JsonIgnore
    public static String getFullTableName(String schema, String table) {
        return schema.equals("default") ? table : schema + '.' + table;
    }

    @JsonIgnore
    public static String getFullTableName(SchemaTableName tableName) {
        return AccumuloTable.getFullTableName(tableName.getSchemaName(), tableName.getTableName());
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schema).add("tableName", (Object)this.table).add("columns", this.columns).add("rowIdName", (Object)this.rowId).add("external", this.external).add("serializerClassName", (Object)this.serializerClassName).add("scanAuthorizations", this.scanAuthorizations).toString();
    }
}

