/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.util.MetadataUtil;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class RaptorOutputTableHandle
implements ConnectorOutputTableHandle {
    private final String connectorId;
    private final long transactionId;
    private final String schemaName;
    private final String tableName;
    private final List<RaptorColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final List<RaptorColumnHandle> sortColumnHandles;
    private final List<SortOrder> sortOrders;
    private final Optional<RaptorColumnHandle> temporalColumnHandle;
    private final OptionalLong distributionId;
    private final OptionalInt bucketCount;
    private final List<RaptorColumnHandle> bucketColumnHandles;
    private final boolean organized;
    private final boolean tableSupportsDeltaDelete;
    private final Map<String, String> properties;

    @JsonCreator
    public RaptorOutputTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="transactionId") long transactionId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnHandles") List<RaptorColumnHandle> columnHandles, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="sortColumnHandles") List<RaptorColumnHandle> sortColumnHandles, @JsonProperty(value="sortOrders") List<SortOrder> sortOrders, @JsonProperty(value="temporalColumnHandle") Optional<RaptorColumnHandle> temporalColumnHandle, @JsonProperty(value="distributionId") OptionalLong distributionId, @JsonProperty(value="bucketCount") OptionalInt bucketCount, @JsonProperty(value="bucketColumnHandles") List<RaptorColumnHandle> bucketColumnHandles, @JsonProperty(value="organized") boolean organized, @JsonProperty(value="tableSupportsDeltaDelete") boolean tableSupportsDeltaDelete, @JsonProperty(value="properties") Map<String, String> properties) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionId = transactionId;
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.sortOrders = Objects.requireNonNull(sortOrders, "sortOrders is null");
        this.sortColumnHandles = Objects.requireNonNull(sortColumnHandles, "sortColumnHandles is null");
        this.temporalColumnHandle = Objects.requireNonNull(temporalColumnHandle, "temporalColumnHandle is null");
        this.distributionId = Objects.requireNonNull(distributionId, "distributionId is null");
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        this.bucketColumnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null"));
        this.organized = organized;
        this.tableSupportsDeltaDelete = tableSupportsDeltaDelete;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public long getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getSortColumnHandles() {
        return this.sortColumnHandles;
    }

    @JsonProperty
    public List<SortOrder> getSortOrders() {
        return this.sortOrders;
    }

    @JsonProperty
    public Optional<RaptorColumnHandle> getTemporalColumnHandle() {
        return this.temporalColumnHandle;
    }

    @JsonProperty
    public OptionalLong getDistributionId() {
        return this.distributionId;
    }

    @JsonProperty
    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getBucketColumnHandles() {
        return this.bucketColumnHandles;
    }

    @JsonProperty
    public boolean isOrganized() {
        return this.organized;
    }

    @JsonProperty
    public boolean isTableSupportsDeltaDelete() {
        return this.tableSupportsDeltaDelete;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "raptor:" + this.schemaName + "." + this.tableName;
    }
}

