/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.raptor.RaptorBucketFunction;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.storage.organization.TemporalFunction;
import com.facebook.presto.raptor.util.PageBuffer;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class RaptorPageSink
implements ConnectorPageSink {
    private static final JsonCodec<ShardInfo> SHARD_INFO_CODEC = JsonCodec.jsonCodec(ShardInfo.class);
    private final long transactionId;
    private final StorageManager storageManager;
    private final PageSorter pageSorter;
    private final List<Long> columnIds;
    private final List<Type> columnTypes;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final OptionalInt bucketCount;
    private final int[] bucketFields;
    private final long maxBufferBytes;
    private final OptionalInt temporalColumnIndex;
    private final Optional<Type> temporalColumnType;
    private final TemporalFunction temporalFunction;
    private final int maxAllowedFilesPerWriter;
    private final FileSystemContext context;
    private final PageWriter pageWriter;

    public RaptorPageSink(FileSystemContext context, PageSorter pageSorter, StorageManager storageManager, TemporalFunction temporalFunction, long transactionId, List<Long> columnIds, List<Type> columnTypes, List<Long> sortColumnIds, List<SortOrder> sortOrders, OptionalInt bucketCount, List<Long> bucketColumnIds, Optional<RaptorColumnHandle> temporalColumnHandle, DataSize maxBufferSize, int maxAllowedFilesPerWriter) {
        this.transactionId = transactionId;
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.temporalFunction = Objects.requireNonNull(temporalFunction, "temporalFunction is null");
        this.columnIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnIds, "columnIds is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.maxBufferBytes = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null").toBytes();
        this.maxAllowedFilesPerWriter = maxAllowedFilesPerWriter;
        this.sortFields = ImmutableList.copyOf((Collection)sortColumnIds.stream().map(columnIds::indexOf).collect(Collectors.toList()));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        this.bucketCount = bucketCount;
        this.bucketFields = bucketColumnIds.stream().mapToInt(columnIds::indexOf).toArray();
        this.context = Objects.requireNonNull(context, "context is null");
        if (temporalColumnHandle.isPresent() && columnIds.contains(temporalColumnHandle.get().getColumnId())) {
            this.temporalColumnIndex = OptionalInt.of(columnIds.indexOf(temporalColumnHandle.get().getColumnId()));
            this.temporalColumnType = Optional.of(columnTypes.get(this.temporalColumnIndex.getAsInt()));
            Preconditions.checkArgument((this.temporalColumnType.get() == DateType.DATE || this.temporalColumnType.get() == TimestampType.TIMESTAMP ? 1 : 0) != 0, (Object)"temporalColumnType can only be DATE or TIMESTAMP");
        } else {
            this.temporalColumnIndex = OptionalInt.empty();
            this.temporalColumnType = Optional.empty();
        }
        this.pageWriter = bucketCount.isPresent() || this.temporalColumnIndex.isPresent() ? new PartitionedPageWriter() : new SimplePageWriter();
    }

    public CompletableFuture<?> appendPage(Page page) {
        if (page.getPositionCount() == 0) {
            return NOT_BLOCKED;
        }
        this.pageWriter.appendPage(page);
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        List futureSlices = this.pageWriter.getPageBuffers().stream().map(pageBuffer -> {
            pageBuffer.flush();
            CompletableFuture<List<ShardInfo>> futureShards = pageBuffer.getStoragePageSink().commit();
            return futureShards.thenApply(shards -> shards.stream().map(shard -> Slices.wrappedBuffer((byte[])SHARD_INFO_CODEC.toJsonBytes(shard))).collect(Collectors.toList()));
        }).collect(Collectors.toList());
        return MoreFutures.allAsList(futureSlices).thenApply(lists -> lists.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public void abort() {
        RuntimeException error = new RuntimeException("Exception during rollback");
        for (PageBuffer pageBuffer : this.pageWriter.getPageBuffers()) {
            try {
                pageBuffer.getStoragePageSink().rollback();
            }
            catch (Throwable t) {
                if (error == t) continue;
                error.addSuppressed(t);
            }
        }
        if (error.getSuppressed().length > 0) {
            throw error;
        }
    }

    private PageBuffer createPageBuffer(OptionalInt bucketNumber) {
        return new PageBuffer(this.maxBufferBytes, this.storageManager.createStoragePageSink(this.context, this.transactionId, bucketNumber, this.columnIds, this.columnTypes, true), this.columnTypes, this.sortFields, this.sortOrders, this.pageSorter);
    }

    private static class PageStore {
        private final PageBuffer pageBuffer;
        private final PageBuilder pageBuilder;

        public PageStore(PageBuffer pageBuffer, List<Type> columnTypes) {
            this.pageBuffer = Objects.requireNonNull(pageBuffer, "pageBuffer is null");
            this.pageBuilder = new PageBuilder(columnTypes);
        }

        public long getUsedMemoryBytes() {
            return this.pageBuilder.getSizeInBytes() + this.pageBuffer.getUsedMemoryBytes();
        }

        public PageBuffer getPageBuffer() {
            return this.pageBuffer;
        }

        public void appendPosition(Page page, int position) {
            this.pageBuilder.declarePosition();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Block block = page.getBlock(channel);
                BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(channel);
                this.pageBuilder.getType(channel).appendTo(block, position, blockBuilder);
            }
            if (this.pageBuilder.isFull()) {
                this.flushToPageBuffer();
            }
        }

        public void flushToPageBuffer() {
            if (!this.pageBuilder.isEmpty()) {
                this.pageBuffer.add(this.pageBuilder.build());
                this.pageBuilder.reset();
            }
        }
    }

    private class PartitionedPageWriter
    implements PageWriter {
        private final Optional<BucketFunction> bucketFunction;
        private final Long2ObjectMap<PageStore> pageStores = new Long2ObjectOpenHashMap();

        public PartitionedPageWriter() {
            Preconditions.checkArgument((RaptorPageSink.this.temporalColumnIndex.isPresent() == RaptorPageSink.this.temporalColumnType.isPresent() ? 1 : 0) != 0, (Object)"temporalColumnIndex and temporalColumnType must be both present or absent");
            List<Type> bucketTypes = Arrays.stream(RaptorPageSink.this.bucketFields).mapToObj(RaptorPageSink.this.columnTypes::get).collect(Collectors.toList());
            this.bucketFunction = RaptorPageSink.this.bucketCount.isPresent() ? Optional.of(new RaptorBucketFunction(RaptorPageSink.this.bucketCount.getAsInt(), bucketTypes)) : Optional.empty();
        }

        @Override
        public void appendPage(Page page) {
            Block temporalBlock = RaptorPageSink.this.temporalColumnIndex.isPresent() ? page.getBlock(RaptorPageSink.this.temporalColumnIndex.getAsInt()) : null;
            Page bucketArgs = this.bucketFunction.isPresent() ? this.getBucketArgsPage(page) : null;
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int day;
                int bucket = this.bucketFunction.isPresent() ? this.bucketFunction.get().getBucket(bucketArgs, position) : 0;
                long partition = (long)bucket << 32 | (long)(day = RaptorPageSink.this.temporalColumnType.isPresent() ? RaptorPageSink.this.temporalFunction.getDay((Type)RaptorPageSink.this.temporalColumnType.get(), temporalBlock, position) : 0) & 0xFFFFFFFFL;
                PageStore store = (PageStore)this.pageStores.get(partition);
                if (store == null) {
                    OptionalInt bucketNumber = this.bucketFunction.isPresent() ? OptionalInt.of(bucket) : OptionalInt.empty();
                    PageBuffer buffer = RaptorPageSink.this.createPageBuffer(bucketNumber);
                    store = new PageStore(buffer, RaptorPageSink.this.columnTypes);
                    this.pageStores.put(partition, (Object)store);
                }
                store.appendPosition(page, position);
            }
            this.flushIfNecessary();
        }

        private Page getBucketArgsPage(Page page) {
            Block[] blocks = new Block[RaptorPageSink.this.bucketFields.length];
            for (int i = 0; i < RaptorPageSink.this.bucketFields.length; ++i) {
                blocks[i] = page.getBlock(RaptorPageSink.this.bucketFields[i]);
            }
            return new Page(page.getPositionCount(), blocks);
        }

        @Override
        public List<PageBuffer> getPageBuffers() {
            ImmutableList.Builder list = ImmutableList.builder();
            for (PageStore store : this.pageStores.values()) {
                store.flushToPageBuffer();
                store.getPageBuffer().flush();
                list.add((Object)store.getPageBuffer());
            }
            return list.build();
        }

        private void flushIfNecessary() {
            long totalBytes = 0L;
            long maxBytes = 0L;
            PageBuffer maxBuffer = null;
            if (this.pageStores.size() > RaptorPageSink.this.maxAllowedFilesPerWriter) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_TOO_MANY_FILES_CREATED, String.format("Number of files created: %s , has exceeded the limit of %s files created per worker per query", this.pageStores.size(), RaptorPageSink.this.maxAllowedFilesPerWriter));
            }
            for (PageStore store : this.pageStores.values()) {
                long bytes = store.getUsedMemoryBytes();
                totalBytes += bytes;
                if (maxBuffer != null && bytes <= maxBytes) continue;
                maxBuffer = store.getPageBuffer();
                maxBytes = bytes;
            }
            if (totalBytes > RaptorPageSink.this.maxBufferBytes && maxBuffer != null) {
                maxBuffer.flush();
            }
        }
    }

    private class SimplePageWriter
    implements PageWriter {
        private final PageBuffer pageBuffer;

        private SimplePageWriter() {
            this.pageBuffer = RaptorPageSink.this.createPageBuffer(OptionalInt.empty());
        }

        @Override
        public void appendPage(Page page) {
            this.pageBuffer.add(page);
        }

        @Override
        public List<PageBuffer> getPageBuffers() {
            return ImmutableList.of((Object)this.pageBuffer);
        }
    }

    private static interface PageWriter {
        public void appendPage(Page var1);

        public List<PageBuffer> getPageBuffers();
    }
}

