/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorSplit;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.util.ConcatPageSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final StorageManager storageManager;

    @Inject
    public RaptorPageSourceProvider(StorageManager storageManager) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        RaptorSplit raptorSplit = (RaptorSplit)split;
        HiveFileContext hiveFileContext = new HiveFileContext(splitContext.isCacheable(), Optional.empty());
        OptionalInt bucketNumber = raptorSplit.getBucketNumber();
        TupleDomain<RaptorColumnHandle> predicate = raptorSplit.getEffectivePredicate();
        ReaderAttributes attributes = ReaderAttributes.from(session);
        OptionalLong transactionId = raptorSplit.getTransactionId();
        Optional<Map<String, Type>> columnTypes = raptorSplit.getColumnTypes();
        boolean tableSupportsDeltaDelete = raptorSplit.isTableSupportsDeltaDelete();
        FileSystemContext context = new FileSystemContext(session);
        Map<UUID, UUID> shardDeltaMap = raptorSplit.getShardDeltaMap();
        if (raptorSplit.getShardUuids().size() == 1) {
            UUID shardUuid2 = raptorSplit.getShardUuids().iterator().next();
            return this.createPageSource(context, hiveFileContext, shardUuid2, Optional.ofNullable(shardDeltaMap.get(shardUuid2)), tableSupportsDeltaDelete, bucketNumber, columns, predicate, attributes, transactionId, columnTypes);
        }
        Iterator<ConnectorPageSource> iterator = raptorSplit.getShardUuids().stream().map(shardUuid -> this.createPageSource(context, hiveFileContext, (UUID)shardUuid, Optional.ofNullable(shardDeltaMap.get(shardUuid)), tableSupportsDeltaDelete, bucketNumber, columns, predicate, attributes, transactionId, columnTypes)).iterator();
        return new ConcatPageSource(iterator);
    }

    private ConnectorPageSource createPageSource(FileSystemContext context, HiveFileContext hiveFileContext, UUID shardUuid, Optional<UUID> deltaShardUuid, boolean tableSupportsDeltaDelete, OptionalInt bucketNumber, List<ColumnHandle> columns, TupleDomain<RaptorColumnHandle> predicate, ReaderAttributes attributes, OptionalLong transactionId, Optional<Map<String, Type>> allColumnTypes) {
        List columnHandles = columns.stream().map(RaptorColumnHandle.class::cast).collect(Collectors.toList());
        List<Long> columnIds = columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
        List<Type> columnTypes = columnHandles.stream().map(RaptorColumnHandle::getColumnType).collect(Collectors.toList());
        return this.storageManager.getPageSource(context, hiveFileContext, shardUuid, deltaShardUuid, tableSupportsDeltaDelete, bucketNumber, columnIds, columnTypes, predicate, attributes, transactionId, allColumnTypes);
    }
}

