/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;

public class RaptorSplit
implements ConnectorSplit {
    private final String connectorId;
    private final Set<UUID> shardUuids;
    private final Map<UUID, UUID> shardDeltaMap;
    private final boolean tableSupportsDeltaDelete;
    private final OptionalInt bucketNumber;
    private final List<HostAddress> addresses;
    private final TupleDomain<RaptorColumnHandle> effectivePredicate;
    private final OptionalLong transactionId;
    private final Optional<Map<String, Type>> columnTypes;

    @JsonCreator
    public RaptorSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="shardUuids") Set<UUID> shardUuids, @JsonProperty(value="shardDeltaMap") Map<UUID, UUID> shardDeltaMap, @JsonProperty(value="tableSupportsDeltaDelete") boolean tableSupportsDeltaDelete, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="effectivePredicate") TupleDomain<RaptorColumnHandle> effectivePredicate, @JsonProperty(value="transactionId") OptionalLong transactionId, @JsonProperty(value="columnTypes") Optional<Map<String, Type>> columnTypes) {
        this(connectorId, shardUuids, shardDeltaMap, tableSupportsDeltaDelete, bucketNumber, (List<HostAddress>)ImmutableList.of(), effectivePredicate, transactionId, columnTypes);
    }

    public RaptorSplit(String connectorId, UUID shardUuid, Optional<UUID> deltaShardUuid, boolean tableSupportsDeltaDelete, List<HostAddress> addresses, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId, Optional<Map<String, Type>> columnTypes) {
        this(connectorId, (Set<UUID>)ImmutableSet.of((Object)shardUuid), (Map<UUID, UUID>)((Map)deltaShardUuid.map(deltaUuid -> ImmutableMap.of((Object)shardUuid, (Object)deltaUuid)).orElse(ImmutableMap.of())), tableSupportsDeltaDelete, OptionalInt.empty(), addresses, effectivePredicate, transactionId, columnTypes);
    }

    public RaptorSplit(String connectorId, Set<UUID> shardUuids, Map<UUID, UUID> shardDeltaMap, boolean tableSupportsDeltaDelete, int bucketNumber, HostAddress address, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId, Optional<Map<String, Type>> columnTypes) {
        this(connectorId, shardUuids, shardDeltaMap, tableSupportsDeltaDelete, OptionalInt.of(bucketNumber), (List<HostAddress>)ImmutableList.of((Object)address), effectivePredicate, transactionId, columnTypes);
    }

    private RaptorSplit(String connectorId, Set<UUID> shardUuids, Map<UUID, UUID> shardDeltaMap, boolean tableSupportsDeltaDelete, OptionalInt bucketNumber, List<HostAddress> addresses, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId, Optional<Map<String, Type>> columnTypes) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.shardUuids = ImmutableSet.copyOf((Collection)Objects.requireNonNull(shardUuids, "shardUuid is null"));
        this.shardDeltaMap = Objects.requireNonNull(shardDeltaMap, "shardUuid is null");
        this.tableSupportsDeltaDelete = tableSupportsDeltaDelete;
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.columnTypes = Objects.requireNonNull(columnTypes, "columnTypes is null");
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.HARD_AFFINITY;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return this.addresses;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public Set<UUID> getShardUuids() {
        return this.shardUuids;
    }

    @JsonProperty
    public Map<UUID, UUID> getShardDeltaMap() {
        return this.shardDeltaMap;
    }

    @JsonProperty
    public boolean isTableSupportsDeltaDelete() {
        return this.tableSupportsDeltaDelete;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public TupleDomain<RaptorColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    @JsonProperty
    public OptionalLong getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public Optional<Map<String, Type>> getColumnTypes() {
        return this.columnTypes;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("shardUuids", this.shardUuids).add("shardDeltaMap", (Object)this.shardDeltaMap.toString()).add("tableSupportsDeltaDelete", this.tableSupportsDeltaDelete).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).add("hosts", this.addresses).omitNullValues().toString();
    }
}

