/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class FileSystemContext {
    public static final FileSystemContext DEFAULT_RAPTOR_CONTEXT = new FileSystemContext(new ConnectorIdentity("presto-raptor", Optional.empty(), Optional.empty()));
    private final ConnectorIdentity identity;
    private final Optional<String> source;
    private final Optional<String> queryId;
    private final Optional<String> clientInfo;

    public FileSystemContext(ConnectorIdentity identity) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Optional.empty();
        this.queryId = Optional.empty();
        this.clientInfo = Optional.empty();
    }

    public FileSystemContext(ConnectorSession session) {
        Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
        this.source = Objects.requireNonNull(session.getSource(), "session.getSource()");
        this.queryId = Optional.of(session.getQueryId());
        this.clientInfo = session.getClientInfo();
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getQueryId() {
        return this.queryId;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("user", (Object)this.identity).add("source", this.source.orElse(null)).add("queryId", this.queryId.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).toString();
    }
}

