/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.orc.OrcDataSink;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OutputStreamOrcDataSink;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.filesystem.HdfsOrcDataSource;
import com.facebook.presto.raptor.filesystem.RaptorHdfsConfiguration;
import com.facebook.presto.raptor.storage.OrcDataEnvironment;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsOrcDataEnvironment
implements OrcDataEnvironment {
    private final Path baseLocation;
    private final RaptorHdfsConfiguration configuration;

    @Inject
    public HdfsOrcDataEnvironment(Path baseLocation, RaptorHdfsConfiguration configuration) {
        this.baseLocation = Objects.requireNonNull(baseLocation, "baseLocation is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
    }

    @Override
    public FileSystem getFileSystem(FileSystemContext fileSystemContext) {
        try {
            return this.baseLocation.getFileSystem(this.configuration.getConfiguration(fileSystemContext, this.baseLocation.toUri()));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_FILE_SYSTEM_ERROR, "Raptor cannot create HDFS file system", (Throwable)e);
        }
    }

    @Override
    public OrcDataSource createOrcDataSource(FileSystem fileSystem, Path path, ReaderAttributes readerAttributes) throws IOException {
        return new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSystem.getFileStatus(path).getLen(), readerAttributes.getMaxMergeDistance(), readerAttributes.getMaxReadSize(), readerAttributes.getStreamBufferSize(), readerAttributes.isLazyReadSmallRanges(), fileSystem.open(path));
    }

    @Override
    public OrcDataSink createOrcDataSink(FileSystem fileSystem, Path path) throws IOException {
        return new OutputStreamOrcDataSink((OutputStream)fileSystem.create(path));
    }
}

