/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.storage.OrcDataEnvironment;
import com.facebook.presto.raptor.storage.StorageService;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsStorageService
implements StorageService {
    private static final String FILE_EXTENSION = ".orc";
    private final Path baseStorageDir;
    private final Path baseQuarantineDir;
    private final OrcDataEnvironment environment;

    @Inject
    public HdfsStorageService(OrcDataEnvironment environment, Path baseLocation) {
        Objects.requireNonNull(baseLocation, "baseLocation is null");
        this.baseStorageDir = new Path(baseLocation, "storage");
        this.baseQuarantineDir = new Path(baseLocation, "quarantine");
        this.environment = Objects.requireNonNull(environment, "environment is null");
    }

    @Override
    @PostConstruct
    public void start() {
        this.createDirectory(this.baseStorageDir);
        this.createDirectory(this.baseQuarantineDir);
    }

    @Override
    public long getAvailableBytes() {
        return Long.MAX_VALUE;
    }

    @Override
    public Path getStorageFile(UUID shardUuid) {
        return HdfsStorageService.getFileSystemPath(this.baseStorageDir, shardUuid);
    }

    @Override
    public Path getStagingFile(UUID shardUuid) {
        return this.getStorageFile(shardUuid);
    }

    @Override
    public Path getQuarantineFile(UUID shardUuid) {
        throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Possible data corruption is detected in metadata or remote storage");
    }

    @Override
    public Set<UUID> getStorageShards() {
        throw new UnsupportedOperationException("HDFS storage does not support list directory on purpose");
    }

    @Override
    public void createParents(Path file) {
        Preconditions.checkArgument((file.getParent().equals((Object)this.baseStorageDir) || file.getParent().equals((Object)this.baseQuarantineDir) ? 1 : 0) != 0);
    }

    @Override
    public void promoteFromStagingToStorage(UUID shardUuid) {
    }

    private static Path getFileSystemPath(Path base, UUID shardUuid) {
        String uuid = shardUuid.toString().toLowerCase(Locale.ENGLISH);
        return new Path(base, uuid + FILE_EXTENSION);
    }

    private void createDirectory(Path directory) {
        boolean madeDirectory;
        try {
            FileSystem fileSystem = this.environment.getFileSystem(FileSystemContext.DEFAULT_RAPTOR_CONTEXT);
            madeDirectory = fileSystem.mkdirs(directory) && fileSystem.isDirectory(directory);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_FILE_SYSTEM_ERROR, "Failed creating directories: " + directory, (Throwable)e);
        }
        if (!madeDirectory) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_FILE_SYSTEM_ERROR, "Failed creating directories: " + directory);
        }
    }
}

