/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.OrcDataSink;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OutputStreamOrcDataSink;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.filesystem.RaptorLocalFileSystem;
import com.facebook.presto.raptor.storage.OrcDataEnvironment;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;

public class LocalOrcDataEnvironment
implements OrcDataEnvironment {
    private static final Configuration CONFIGURATION = new Configuration();
    private final RawLocalFileSystem localFileSystem;

    @Inject
    public LocalOrcDataEnvironment() {
        try {
            this.localFileSystem = new RaptorLocalFileSystem(CONFIGURATION);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_FILE_SYSTEM_ERROR, "Raptor cannot create local file system", (Throwable)e);
        }
    }

    @Override
    public FileSystem getFileSystem(FileSystemContext ignore) {
        return this.localFileSystem;
    }

    public RawLocalFileSystem getLocalFileSystem() {
        return this.localFileSystem;
    }

    @Override
    public OrcDataSource createOrcDataSource(FileSystem ignore, Path path, ReaderAttributes readerAttributes) throws IOException {
        return new FileOrcDataSource(this.localFileSystem.pathToFile(path), readerAttributes.getMaxMergeDistance(), readerAttributes.getMaxReadSize(), readerAttributes.getStreamBufferSize(), readerAttributes.isLazyReadSmallRanges());
    }

    @Override
    public OrcDataSink createOrcDataSink(FileSystem fileSystem, Path path) throws IOException {
        return new OutputStreamOrcDataSink((OutputStream)new FileOutputStream(this.localFileSystem.pathToFile(path)));
    }

    public static Optional<RawLocalFileSystem> tryGetLocalFileSystem(OrcDataEnvironment environment) {
        if (environment instanceof LocalOrcDataEnvironment) {
            return Optional.of(((LocalOrcDataEnvironment)environment).getLocalFileSystem());
        }
        return Optional.empty();
    }
}

