/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.hadoop.HadoopFileSystemCache;
import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.filesystem.FileSystemUtil;
import com.facebook.presto.raptor.filesystem.RaptorHdfsConfig;
import com.facebook.presto.raptor.filesystem.RaptorHdfsConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.SocksSocketFactory;

public class RaptorHiveHdfsConfiguration
implements RaptorHdfsConfiguration {
    private static final Configuration INITIAL_CONFIGURATION;
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration configuration = new Configuration(false);
            FileSystemUtil.copy(INITIAL_CONFIGURATION, configuration);
            RaptorHiveHdfsConfiguration.this.initializer.updateConfiguration(configuration);
            return configuration;
        }
    };
    private final HdfsConfigurationInitializer initializer;

    @Inject
    public RaptorHiveHdfsConfiguration(RaptorHdfsConfig config) {
        this.initializer = new HdfsConfigurationInitializer(Objects.requireNonNull(config, "config is null"));
    }

    @Override
    public Configuration getConfiguration(FileSystemContext context, URI uri) {
        return this.hadoopConfiguration.get();
    }

    static {
        HadoopNative.requireHadoopNative();
        HadoopFileSystemCache.initialize();
        INITIAL_CONFIGURATION = FileSystemUtil.getInitialConfiguration();
    }

    private static class HdfsConfigurationInitializer {
        private final HostAndPort socksProxy;
        private final Duration ipcPingInterval;
        private final Duration dfsTimeout;
        private final Duration dfsConnectTimeout;
        private final int dfsConnectMaxRetries;
        private final String domainSocketPath;
        private final Configuration resourcesConfiguration;
        private final int fileSystemMaxCacheSize;
        private final boolean isHdfsWireEncryptionEnabled;
        private int textMaxLineLength;

        public HdfsConfigurationInitializer(RaptorHdfsConfig config) {
            Objects.requireNonNull(config, "config is null");
            Preconditions.checkArgument((config.getDfsTimeout().toMillis() >= 1L ? 1 : 0) != 0, (Object)"dfsTimeout must be at least 1 ms");
            Preconditions.checkArgument((Math.toIntExact(config.getTextMaxLineLength().toBytes()) >= 1 ? 1 : 0) != 0, (Object)"textMaxLineLength must be at least 1 byte");
            this.socksProxy = config.getSocksProxy();
            this.ipcPingInterval = config.getIpcPingInterval();
            this.dfsTimeout = config.getDfsTimeout();
            this.dfsConnectTimeout = config.getDfsConnectTimeout();
            this.dfsConnectMaxRetries = config.getDfsConnectMaxRetries();
            this.domainSocketPath = config.getDomainSocketPath();
            this.resourcesConfiguration = HdfsConfigurationInitializer.readConfiguration(config.getResourceConfigFiles());
            this.fileSystemMaxCacheSize = config.getFileSystemMaxCacheSize();
            this.isHdfsWireEncryptionEnabled = config.isHdfsWireEncryptionEnabled();
            this.textMaxLineLength = Math.toIntExact(config.getTextMaxLineLength().toBytes());
        }

        private static Configuration readConfiguration(List<String> resourcePaths) {
            Configuration result = new Configuration(false);
            for (String resourcePath : resourcePaths) {
                Configuration resourceProperties = new Configuration(false);
                resourceProperties.addResource(new Path(resourcePath));
                FileSystemUtil.copy(resourceProperties, result);
            }
            return result;
        }

        public void updateConfiguration(Configuration config) {
            FileSystemUtil.copy(this.resourcesConfiguration, config);
            config.setClass("net.topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
            if (this.socksProxy != null) {
                config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
                config.set("hadoop.socks.server", this.socksProxy.toString());
            }
            if (this.domainSocketPath != null) {
                config.setStrings("dfs.domain.socket.path", new String[]{this.domainSocketPath});
            }
            if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
                config.setBooleanIfUnset("dfs.client.read.shortcircuit", true);
            }
            config.setInt("dfs.client.socket-timeout", Math.toIntExact(this.dfsTimeout.toMillis()));
            config.setInt("ipc.ping.interval", Math.toIntExact(this.ipcPingInterval.toMillis()));
            config.setInt("ipc.client.connect.timeout", Math.toIntExact(this.dfsConnectTimeout.toMillis()));
            config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
            if (this.isHdfsWireEncryptionEnabled) {
                config.set("hadoop.rpc.protection", "privacy");
                config.setBoolean("dfs.encrypt.data.transfer", true);
            }
            config.setInt("fs.cache.max-size", this.fileSystemMaxCacheSize);
            config.setInt("mapreduce.input.linerecordreader.line.maxlength", this.textMaxLineLength);
        }

        public static class NoOpDNSToSwitchMapping
        implements DNSToSwitchMapping {
            public List<String> resolve(List<String> names) {
                return ImmutableList.of();
            }

            public void reloadCachedMappings() {
            }

            public void reloadCachedMappings(List<String> names) {
            }
        }
    }
}

