/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.ShardDao;
import com.facebook.presto.raptor.util.UuidUtil;
import java.sql.Timestamp;
import java.util.UUID;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterArgumentFactory;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapperFactory;

@RegisterArgumentFactory(value={UuidUtil.UuidArgumentFactory.class})
@RegisterMapperFactory(value={UuidUtil.UuidMapperFactory.class})
public interface MySqlShardDao
extends ShardDao {
    @Override
    @SqlUpdate(value="DELETE x\nFROM shard_nodes x\nJOIN shards USING (shard_id)\nWHERE table_id = :tableId")
    public void dropShardNodes(@Bind(value="tableId") long var1);

    @Override
    @SqlBatch(value="INSERT IGNORE INTO deleted_shards (shard_uuid, delete_time)\nVALUES (:shardUuid, CURRENT_TIMESTAMP)")
    public void insertDeletedShards(@Bind(value="shardUuid") Iterable<UUID> var1);

    @Override
    @SqlUpdate(value="DELETE FROM transactions\nWHERE end_time < :maxEndTime\n  AND successful IN (TRUE, FALSE)\n  AND transaction_id NOT IN (SELECT transaction_id FROM created_shards)\nORDER BY end_time, transaction_id\nLIMIT 10000")
    public int deleteOldCompletedTransactions(@Bind(value="maxEndTime") Timestamp var1);
}

