/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.storage.OrcStorageManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;

public class DeltaShardLoader {
    private static final RowsToKeepResult KEEP_ALL = new RowsToKeepResult(true, new IntArrayList(0));
    private final Optional<UUID> deltaShardUuid;
    private final boolean tableSupportsDeltaDelete;
    private final OrcStorageManager orcStorageManager;
    private final FileSystem fileSystem;
    private boolean loaded;
    private Optional<BitSet> rowsDeleted = Optional.empty();

    public DeltaShardLoader(Optional<UUID> deltaShardUuid, boolean tableSupportsDeltaDelete, OrcStorageManager orcStorageManager, FileSystem fileSystem) {
        this.deltaShardUuid = Objects.requireNonNull(deltaShardUuid, "deltaShardUuid is null");
        this.tableSupportsDeltaDelete = tableSupportsDeltaDelete;
        this.orcStorageManager = Objects.requireNonNull(orcStorageManager, "storageManager is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
    }

    public RowsToKeepResult getRowsToKeep(int batchSize, long filePosition) {
        Optional<BitSet> rowsDeleted = this.getRowsDeleted();
        if (rowsDeleted.isPresent() && rowsDeleted.get().cardinality() > 0) {
            IntArrayList rowsToKeep = new IntArrayList(batchSize);
            for (int position = 0; position < batchSize; ++position) {
                if (rowsDeleted.get().get(Math.toIntExact(filePosition) + position)) continue;
                rowsToKeep.add(position);
            }
            if (rowsToKeep.size() == batchSize) {
                return KEEP_ALL;
            }
            return new RowsToKeepResult(false, rowsToKeep);
        }
        return KEEP_ALL;
    }

    private Optional<BitSet> getRowsDeleted() {
        if (!this.loaded && this.tableSupportsDeltaDelete && this.deltaShardUuid.isPresent()) {
            this.rowsDeleted = this.orcStorageManager.getRowsFromUuid(this.fileSystem, this.deltaShardUuid);
            this.loaded = true;
        }
        return this.rowsDeleted;
    }

    static class RowsToKeepResult {
        private final boolean keepAll;
        private final IntArrayList rowsToKeep;

        private RowsToKeepResult(boolean keepAll, IntArrayList rowsToKeep) {
            this.keepAll = keepAll;
            this.rowsToKeep = Objects.requireNonNull(rowsToKeep, "rowsToKeep is null");
        }

        public boolean keepAll() {
            return this.keepAll;
        }

        public int size() {
            return this.rowsToKeep.size();
        }

        public IntArrayList getRowsToKeep() {
            return this.rowsToKeep;
        }

        public int[] elements() {
            return this.rowsToKeep.elements();
        }
    }
}

