/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.filesystem.FileSystemContext;
import com.facebook.presto.raptor.metadata.DeltaInfoPair;
import com.facebook.presto.raptor.metadata.ShardDeleteDelta;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.storage.OrcStorageManager;
import com.facebook.presto.raptor.storage.ShardRewriter;
import com.facebook.presto.raptor.storage.StoragePageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LongArrayBlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.FileSystem;

public class DeltaShardRewriter
implements ShardRewriter {
    private static final JsonCodec<ShardDeleteDelta> SHARD_DELETE_DELTA_CODEC = JsonCodec.jsonCodec(ShardDeleteDelta.class);
    private final UUID oldShardUuid;
    private final int oldShardRowCount;
    private final Optional<UUID> oldDeltaDeleteShardUuid;
    private final ExecutorService deletionExecutor;
    private final long transactionId;
    private final OptionalInt bucketNumber;
    private final OrcStorageManager orcStorageManager;
    private final FileSystemContext fileSystemContext;
    private final FileSystem fileSystem;

    public DeltaShardRewriter(UUID oldShardUuid, int oldShardRowCount, Optional<UUID> oldDeltaDeleteShardUuid, ExecutorService deletionExecutor, long transactionId, OptionalInt bucketNumber, OrcStorageManager orcStorageManager, FileSystemContext fileSystemContext, FileSystem fileSystem) {
        this.oldShardUuid = Objects.requireNonNull(oldShardUuid, "oldShardUuid is null");
        this.oldShardRowCount = oldShardRowCount;
        this.oldDeltaDeleteShardUuid = Objects.requireNonNull(oldDeltaDeleteShardUuid, "Optional oldDeltaDeleteShardUuid is null");
        this.deletionExecutor = Objects.requireNonNull(deletionExecutor, "deletionExecutor is null");
        this.transactionId = transactionId;
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.orcStorageManager = Objects.requireNonNull(orcStorageManager, "orcStorageManager is null");
        this.fileSystemContext = Objects.requireNonNull(fileSystemContext, "fileSystemContext is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
    }

    @Override
    public CompletableFuture<Collection<Slice>> rewrite(BitSet rowsToDelete) {
        if (rowsToDelete.isEmpty()) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        return CompletableFuture.supplyAsync(() -> this.writeDeltaDeleteFile(rowsToDelete), this.deletionExecutor);
    }

    @VisibleForTesting
    Collection<Slice> writeDeltaDeleteFile(BitSet rowsToDelete) {
        if (rowsToDelete.isEmpty()) {
            return ImmutableList.of();
        }
        this.oldDeltaDeleteShardUuid.ifPresent(oldDeltaDeleteShardUuid -> this.mergeToRowsToDelete(rowsToDelete, (UUID)oldDeltaDeleteShardUuid));
        if (rowsToDelete.cardinality() == this.oldShardRowCount) {
            return DeltaShardRewriter.shardDeleteDelta(this.oldShardUuid, this.oldDeltaDeleteShardUuid, Optional.empty());
        }
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, rowsToDelete.size());
        int i = rowsToDelete.nextSetBit(0);
        while (i >= 0) {
            blockBuilder.writeLong((long)i);
            i = rowsToDelete.nextSetBit(i + 1);
        }
        StoragePageSink pageSink = this.orcStorageManager.createStoragePageSink(this.fileSystemContext, this.transactionId, this.bucketNumber, (List<Long>)ImmutableList.of((Object)0L), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), true);
        pageSink.appendPages((List<Page>)ImmutableList.of((Object)new Page(new Block[]{blockBuilder.build()})));
        List shardInfos = (List)MoreFutures.getFutureValue(pageSink.commit());
        ShardInfo newDeltaDeleteShard = (ShardInfo)Iterables.getOnlyElement((Iterable)shardInfos);
        return DeltaShardRewriter.shardDeleteDelta(this.oldShardUuid, this.oldDeltaDeleteShardUuid, Optional.of(newDeltaDeleteShard));
    }

    private void mergeToRowsToDelete(BitSet rowsToDelete, UUID oldDeltaDeleteShardUuid) {
        Optional<BitSet> rowsDeleted = this.orcStorageManager.getRowsFromUuid(this.fileSystem, Optional.of(oldDeltaDeleteShardUuid));
        if (!rowsDeleted.isPresent()) {
            return;
        }
        BitSet verify = new BitSet();
        verify.or(rowsToDelete);
        verify.and(rowsDeleted.get());
        if (verify.cardinality() != 0) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "rowsToDelete and rowsDeleted are not mutually exclusive");
        }
        rowsToDelete.or(rowsDeleted.get());
    }

    private static Collection<Slice> shardDeleteDelta(UUID oldShardUuid, Optional<UUID> oldDeltaDeleteShard, Optional<ShardInfo> newDeltaDeleteShard) {
        return ImmutableList.of((Object)Slices.wrappedBuffer((byte[])SHARD_DELETE_DELTA_CODEC.toJsonBytes((Object)new ShardDeleteDelta(oldShardUuid, new DeltaInfoPair(oldDeltaDeleteShard, newDeltaDeleteShard)))));
    }
}

