/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.orc.OrcDataSink;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.storage.FileWriter;
import com.facebook.presto.raptor.storage.OrcFileMetadata;
import com.facebook.presto.raptor.storage.OrcStorageManager;
import com.facebook.presto.raptor.storage.StorageTypeConverter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrcFileWriter
implements FileWriter {
    public static final OrcWriterOptions DEFAULT_OPTION = new OrcWriterOptions();
    private static final JsonCodec<OrcFileMetadata> METADATA_CODEC = JsonCodec.jsonCodec(OrcFileMetadata.class);
    private final OrcWriter orcWriter;
    private boolean closed;
    private long rowCount;
    private long uncompressedSize;

    public OrcFileWriter(List<Long> columnIds, List<Type> columnTypes, OrcDataSink target, boolean validate, OrcWriterStats stats, TypeManager typeManager, CompressionKind compression) {
        this(columnIds, columnTypes, target, true, validate, stats, typeManager, compression);
    }

    @VisibleForTesting
    OrcFileWriter(List<Long> columnIds, List<Type> columnTypes, OrcDataSink target, boolean writeMetadata, boolean validate, OrcWriterStats stats, TypeManager typeManager, CompressionKind compression) {
        Preconditions.checkArgument((Objects.requireNonNull(columnIds, "columnIds is null").size() == Objects.requireNonNull(columnTypes, "columnTypes is null").size() ? 1 : 0) != 0, (Object)"ids and types mismatch");
        Preconditions.checkArgument((boolean)OrcFileWriter.isUnique(columnIds), (Object)"ids must be unique");
        StorageTypeConverter converter = new StorageTypeConverter(typeManager);
        List storageTypes = (List)columnTypes.stream().map(converter::toStorageType).collect(ImmutableList.toImmutableList());
        List columnNames = (List)columnIds.stream().map(Object::toString).collect(ImmutableList.toImmutableList());
        ImmutableMap userMetadata = ImmutableMap.of();
        if (writeMetadata) {
            ImmutableMap.Builder columnTypesMap = ImmutableMap.builder();
            for (int i = 0; i < columnIds.size(); ++i) {
                columnTypesMap.put((Object)columnIds.get(i), (Object)columnTypes.get(i).getTypeSignature());
            }
            userMetadata = ImmutableMap.of((Object)"metadata", (Object)METADATA_CODEC.toJson((Object)new OrcFileMetadata((Map<Long, TypeSignature>)columnTypesMap.build())));
        }
        this.orcWriter = new OrcWriter(target, columnNames, storageTypes, OrcEncoding.ORC, Objects.requireNonNull(compression, "compression is null"), DEFAULT_OPTION, (Map)userMetadata, OrcStorageManager.DEFAULT_STORAGE_TIMEZONE, validate, OrcWriteValidation.OrcWriteValidationMode.HASHED, stats);
    }

    @Override
    public void appendPages(List<Page> pages) {
        for (Page page : pages) {
            try {
                this.orcWriter.write(page);
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_WRITER_DATA_ERROR, (Throwable)e);
            }
            this.uncompressedSize += page.getLogicalSizeInBytes();
            this.rowCount += (long)page.getPositionCount();
        }
    }

    @Override
    public void appendPages(List<Page> inputPages, int[] pageIndexes, int[] positionIndexes) {
        Preconditions.checkArgument((pageIndexes.length == positionIndexes.length ? 1 : 0) != 0, (Object)"pageIndexes and positionIndexes do not match");
        for (int i = 0; i < pageIndexes.length; ++i) {
            Page page = inputPages.get(pageIndexes[i]);
            Page singleValuePage = page.getSingleValuePage(positionIndexes[i]);
            try {
                this.orcWriter.write(singleValuePage);
                this.uncompressedSize += singleValuePage.getLogicalSizeInBytes();
                ++this.rowCount;
                continue;
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_WRITER_DATA_ERROR, (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.orcWriter.close();
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    private static <T> boolean isUnique(Collection<T> items) {
        return new HashSet<T>(items).size() == items.size();
    }
}

