/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.presto.raptor.metadata.Table;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.storage.organization.ShardIndexInfo;
import com.facebook.presto.raptor.storage.organization.ShardOrganizerUtil;
import com.facebook.presto.raptor.storage.organization.ShardRange;
import com.facebook.presto.raptor.storage.organization.TemporalFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CompactionSetCreator {
    private final DataSize maxShardSize;
    private final long maxShardRows;
    private final TemporalFunction temporalFunction;

    public CompactionSetCreator(TemporalFunction temporalFunction, DataSize maxShardSize, long maxShardRows) {
        Preconditions.checkArgument((maxShardRows > 0L ? 1 : 0) != 0, (Object)"maxShardRows must be > 0");
        this.temporalFunction = Objects.requireNonNull(temporalFunction, "temporalFunction is null");
        this.maxShardSize = Objects.requireNonNull(maxShardSize, "maxShardSize is null");
        this.maxShardRows = maxShardRows;
    }

    public Set<OrganizationSet> createCompactionSets(Table tableInfo, Collection<ShardIndexInfo> shards) {
        Collection<Collection<ShardIndexInfo>> shardsByDaysBuckets = ShardOrganizerUtil.getShardsByDaysBuckets(tableInfo, shards, this.temporalFunction);
        ImmutableSet.Builder compactionSets = ImmutableSet.builder();
        for (Collection<ShardIndexInfo> shardInfos : shardsByDaysBuckets) {
            compactionSets.addAll(this.buildCompactionSets(tableInfo, (Set<ShardIndexInfo>)ImmutableSet.copyOf(shardInfos)));
        }
        return compactionSets.build();
    }

    private Set<OrganizationSet> buildCompactionSets(Table tableInfo, Set<ShardIndexInfo> shardIndexInfos) {
        long tableId = tableInfo.getTableId();
        List shards = shardIndexInfos.stream().sorted(CompactionSetCreator.getShardIndexInfoComparator(tableInfo)).collect(Collectors.toCollection(ArrayList::new));
        long consumedBytes = 0L;
        long consumedRows = 0L;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet.Builder compactionSets = ImmutableSet.builder();
        int priority = 0;
        for (ShardIndexInfo shard : shards) {
            if (consumedBytes + shard.getUncompressedSize() > this.maxShardSize.toBytes() || consumedRows + shard.getRowCount() > this.maxShardRows) {
                ImmutableSet shardsToCompact = builder.build();
                this.addToCompactionSets((ImmutableSet.Builder<OrganizationSet>)compactionSets, (Set<ShardIndexInfo>)shardsToCompact, tableId, tableInfo, priority);
                priority = 0;
                builder = ImmutableSet.builder();
                consumedBytes = 0L;
                consumedRows = 0L;
            }
            if (shard.getDeltaUuid().isPresent()) {
                ++priority;
            }
            builder.add((Object)shard);
            consumedBytes += shard.getUncompressedSize();
            consumedRows += shard.getRowCount();
        }
        ImmutableSet shardsToCompact = builder.build();
        this.addToCompactionSets((ImmutableSet.Builder<OrganizationSet>)compactionSets, (Set<ShardIndexInfo>)shardsToCompact, tableId, tableInfo, priority);
        return compactionSets.build();
    }

    private void addToCompactionSets(ImmutableSet.Builder<OrganizationSet> compactionSets, Set<ShardIndexInfo> shardsToCompact, long tableId, Table tableInfo, int priority) {
        if (shardsToCompact.size() > 1 || shardsToCompact.stream().anyMatch(shard -> shard.getDeltaUuid().isPresent())) {
            compactionSets.add((Object)ShardOrganizerUtil.createOrganizationSet(tableId, tableInfo.isTableSupportsDeltaDelete(), shardsToCompact, priority));
        }
    }

    private static Comparator<ShardIndexInfo> getShardIndexInfoComparator(Table tableInfo) {
        if (!tableInfo.getTemporalColumnId().isPresent()) {
            return Comparator.comparing(ShardIndexInfo::getUncompressedSize);
        }
        return Comparator.comparing(info -> info.getTemporalRange().get(), Comparator.comparing(ShardRange::getMinTuple).thenComparing(ShardRange::getMaxTuple));
    }
}

