/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.metadata.TableColumn;
import com.facebook.presto.raptor.metadata.TableMetadata;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.storage.organization.ShardCompactor;
import com.facebook.presto.spi.block.SortOrder;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.stream.Collectors;

class OrganizationJob
implements Runnable {
    private static final Logger log = Logger.get(OrganizationJob.class);
    private final MetadataDao metadataDao;
    private final ShardManager shardManager;
    private final ShardCompactor compactor;
    private final OrganizationSet organizationSet;

    public OrganizationJob(OrganizationSet organizationSet, MetadataDao metadataDao, ShardManager shardManager, ShardCompactor compactor) {
        this.metadataDao = Objects.requireNonNull(metadataDao, "metadataDao is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.compactor = Objects.requireNonNull(compactor, "compactor is null");
        this.organizationSet = Objects.requireNonNull(organizationSet, "organizationSet is null");
    }

    @Override
    public void run() {
        try {
            this.runJob(this.organizationSet.getTableId(), this.organizationSet.isTableSupportsDeltaDelete(), this.organizationSet.getBucketNumber(), this.organizationSet.getShardsMap());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void runJob(long tableId, boolean tableSupportsDeltaDelete, OptionalInt bucketNumber, Map<UUID, Optional<UUID>> shardUuidsMap) throws IOException {
        long transactionId = this.shardManager.beginTransaction();
        try {
            this.runJob(transactionId, tableSupportsDeltaDelete, bucketNumber, tableId, shardUuidsMap);
        }
        catch (Throwable e) {
            this.shardManager.rollbackTransaction(transactionId);
            throw e;
        }
    }

    private void runJob(long transactionId, boolean tableSupportsDeltaDelete, OptionalInt bucketNumber, long tableId, Map<UUID, Optional<UUID>> shardUuidsMap) throws IOException {
        TableMetadata metadata = this.getTableMetadata(tableId);
        List<ShardInfo> newShards = this.performCompaction(transactionId, tableSupportsDeltaDelete, bucketNumber, shardUuidsMap, metadata);
        log.info("Compacted shards %s into %s for table: %s", new Object[]{shardUuidsMap, newShards.stream().map(ShardInfo::getShardUuid).collect(Collectors.toList()), tableId});
        if (tableSupportsDeltaDelete) {
            this.shardManager.replaceShardUuids(transactionId, tableId, metadata.getColumns(), shardUuidsMap, newShards, OptionalLong.empty(), true);
        } else {
            this.shardManager.replaceShardUuids(transactionId, tableId, metadata.getColumns(), shardUuidsMap.keySet(), newShards, OptionalLong.empty());
        }
    }

    private TableMetadata getTableMetadata(long tableId) {
        List<TableColumn> sortColumns = this.metadataDao.listSortColumns(tableId);
        List<Long> sortColumnIds = sortColumns.stream().map(TableColumn::getColumnId).collect(Collectors.toList());
        List<ColumnInfo> columns = this.metadataDao.listTableColumns(tableId).stream().map(TableColumn::toColumnInfo).collect(Collectors.toList());
        return new TableMetadata(tableId, columns, sortColumnIds);
    }

    private List<ShardInfo> performCompaction(long transactionId, boolean tableSupportsDeltaDelete, OptionalInt bucketNumber, Map<UUID, Optional<UUID>> shardUuidsMap, TableMetadata tableMetadata) throws IOException {
        if (tableMetadata.getSortColumnIds().isEmpty()) {
            return this.compactor.compact(transactionId, tableSupportsDeltaDelete, bucketNumber, shardUuidsMap, tableMetadata.getColumns());
        }
        return this.compactor.compactSorted(transactionId, tableSupportsDeltaDelete, bucketNumber, shardUuidsMap, tableMetadata.getColumns(), tableMetadata.getSortColumnIds(), Collections.nCopies(tableMetadata.getSortColumnIds().size(), SortOrder.ASC_NULLS_FIRST));
    }

    public int getPriority() {
        return this.organizationSet.getPriority();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metadataDao", (Object)this.metadataDao).add("shardManager", (Object)this.shardManager).add("compactor", (Object)this.compactor).add("organizationSet", (Object)this.organizationSet).add("priority", this.organizationSet.getPriority()).toString();
    }
}

