/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class OrganizationSet {
    private final long tableId;
    private final boolean tableSupportsDeltaDelete;
    private final Map<UUID, Optional<UUID>> shardsMap;
    private final OptionalInt bucketNumber;
    private final int priority;

    public OrganizationSet(long tableId, boolean tableSupportsDeltaDelete, Map<UUID, Optional<UUID>> shardsMap, OptionalInt bucketNumber, int priority) {
        this.tableId = tableId;
        this.tableSupportsDeltaDelete = tableSupportsDeltaDelete;
        this.shardsMap = Objects.requireNonNull(shardsMap, "shards is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.priority = priority;
    }

    public long getTableId() {
        return this.tableId;
    }

    public boolean isTableSupportsDeltaDelete() {
        return this.tableSupportsDeltaDelete;
    }

    public Map<UUID, Optional<UUID>> getShardsMap() {
        return this.shardsMap;
    }

    public Set<UUID> getShards() {
        return this.shardsMap.keySet();
    }

    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationSet that = (OrganizationSet)o;
        return this.tableId == that.tableId && this.tableSupportsDeltaDelete == that.tableSupportsDeltaDelete && Objects.equals(this.shardsMap, that.shardsMap) && Objects.equals(this.bucketNumber, that.bucketNumber);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.tableSupportsDeltaDelete, this.shardsMap, this.bucketNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("tableSupportsDeltaDelete", this.tableSupportsDeltaDelete).add("shardSize", this.shardsMap.size()).add("deltaSize", this.shardsMap.values().stream().filter(Optional::isPresent).collect(Collectors.toSet()).size()).add("priority", this.priority).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).omitNullValues().toString();
    }
}

