/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.facebook.presto.raptor.metadata.Table;
import com.facebook.presto.raptor.metadata.TableColumn;
import com.facebook.presto.raptor.storage.ColumnIndexStatsUtils;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.storage.organization.ShardIndexInfo;
import com.facebook.presto.raptor.storage.organization.ShardRange;
import com.facebook.presto.raptor.storage.organization.TemporalFunction;
import com.facebook.presto.raptor.storage.organization.Tuple;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import io.airlift.slice.Slices;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.skife.jdbi.v2.IDBI;

public class ShardOrganizerUtil {
    private ShardOrganizerUtil() {
    }

    public static Collection<ShardIndexInfo> getOrganizationEligibleShards(IDBI dbi, MetadataDao metadataDao, Table tableInfo, Collection<ShardMetadata> shards, boolean includeSortColumns) {
        ImmutableMap shardsById = Maps.uniqueIndex(shards, ShardMetadata::getShardId);
        long tableId = tableInfo.getTableId();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        columnsBuilder.add((Object)"shard_id");
        Optional<Object> temporalColumn = Optional.empty();
        if (tableInfo.getTemporalColumnId().isPresent()) {
            long temporalColumnId = tableInfo.getTemporalColumnId().getAsLong();
            temporalColumn = Optional.of(metadataDao.getTableColumn(tableId, temporalColumnId));
            columnsBuilder.add((Object[])new String[]{DatabaseShardManager.minColumn(temporalColumnId), DatabaseShardManager.maxColumn(temporalColumnId)});
        }
        Optional<Object> sortColumns = Optional.empty();
        if (includeSortColumns) {
            sortColumns = Optional.of(metadataDao.listSortColumns(tableId));
            for (TableColumn column : (List)sortColumns.get()) {
                columnsBuilder.add((Object[])new String[]{DatabaseShardManager.minColumn(column.getColumnId()), DatabaseShardManager.maxColumn(column.getColumnId())});
            }
        }
        String columnToSelect = Joiner.on((String)",\n").join((Iterable)columnsBuilder.build());
        ImmutableList.Builder indexInfoBuilder = ImmutableList.builder();
        try (Connection connection = dbi.open().getConnection();){
            for (List partitionedShards : Iterables.partition(shards, (int)1000)) {
                String shardIds = Joiner.on((String)",").join(Collections.nCopies(partitionedShards.size(), "?"));
                String sql = String.format("SELECT %s\nFROM %s\nWHERE shard_id IN (%s)", columnToSelect, DatabaseShardManager.shardIndexTable(tableId), shardIds);
                PreparedStatement statement = connection.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    for (int i = 0; i < partitionedShards.size(); ++i) {
                        statement.setLong(i + 1, ((ShardMetadata)partitionedShards.get(i)).getShardId());
                    }
                    ResultSet resultSet = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (resultSet.next()) {
                            long shardId = resultSet.getLong("shard_id");
                            Optional<Object> sortRange = Optional.empty();
                            if (includeSortColumns && !(sortRange = ShardOrganizerUtil.getShardRange((List)sortColumns.get(), resultSet)).isPresent()) continue;
                            Optional<Object> temporalRange = Optional.empty();
                            if (temporalColumn.isPresent() && !(temporalRange = ShardOrganizerUtil.getShardRange((List<TableColumn>)ImmutableList.of((Object)temporalColumn.get()), resultSet)).isPresent()) continue;
                            ShardMetadata shardMetadata = (ShardMetadata)shardsById.get(shardId);
                            indexInfoBuilder.add((Object)ShardOrganizerUtil.toShardIndexInfo(shardMetadata, temporalRange, sortRange));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return indexInfoBuilder.build();
    }

    private static ShardIndexInfo toShardIndexInfo(ShardMetadata shardMetadata, Optional<ShardRange> temporalRange, Optional<ShardRange> sortRange) {
        return new ShardIndexInfo(shardMetadata.getTableId(), shardMetadata.getBucketNumber(), shardMetadata.getShardUuid(), shardMetadata.isDelta(), shardMetadata.getDeltaUuid(), shardMetadata.getRowCount(), shardMetadata.getUncompressedSize(), sortRange, temporalRange);
    }

    public static Collection<Collection<ShardIndexInfo>> getShardsByDaysBuckets(Table tableInfo, Collection<ShardIndexInfo> shards, TemporalFunction temporalFunction) {
        if (shards.isEmpty()) {
            return ImmutableList.of();
        }
        if (!tableInfo.getBucketCount().isPresent() && !tableInfo.getTemporalColumnId().isPresent()) {
            return ImmutableList.of(shards);
        }
        if (tableInfo.getBucketCount().isPresent() && !tableInfo.getTemporalColumnId().isPresent()) {
            return Multimaps.index(shards, shard -> shard.getBucketNumber().getAsInt()).asMap().values();
        }
        ImmutableMultimap.Builder shardsByDaysBuilder = ImmutableMultimap.builder();
        shards.stream().filter(shard -> shard.getTemporalRange().isPresent()).forEach(shard -> {
            long day = temporalFunction.getDayFromRange(shard.getTemporalRange().get());
            shardsByDaysBuilder.put((Object)day, shard);
        });
        ImmutableCollection byDays = shardsByDaysBuilder.build().asMap().values();
        if (!tableInfo.getBucketCount().isPresent()) {
            return byDays;
        }
        ImmutableList.Builder sets = ImmutableList.builder();
        for (Collection s : byDays) {
            sets.addAll((Iterable)Multimaps.index((Iterable)s, ShardIndexInfo::getBucketNumber).asMap().values());
        }
        return sets.build();
    }

    private static Optional<ShardRange> getShardRange(List<TableColumn> columns, ResultSet resultSet) throws SQLException {
        ImmutableList.Builder minValuesBuilder = ImmutableList.builder();
        ImmutableList.Builder maxValuesBuilder = ImmutableList.builder();
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (TableColumn tableColumn : columns) {
            long columnId = tableColumn.getColumnId();
            Type type = tableColumn.getDataType();
            Object min = ShardOrganizerUtil.getValue(resultSet, type, DatabaseShardManager.minColumn(columnId));
            Object max = ShardOrganizerUtil.getValue(resultSet, type, DatabaseShardManager.maxColumn(columnId));
            if (min == null || max == null) {
                return Optional.empty();
            }
            minValuesBuilder.add(min);
            maxValuesBuilder.add(max);
            typeBuilder.add((Object)type);
        }
        ImmutableList types = typeBuilder.build();
        Tuple minTuple = new Tuple((List<Type>)types, (List<Object>)minValuesBuilder.build());
        Tuple maxTuple = new Tuple((List<Type>)types, (List<Object>)maxValuesBuilder.build());
        return Optional.of(ShardRange.of(minTuple, maxTuple));
    }

    private static Object getValue(ResultSet resultSet, Type type, String columnName) throws SQLException {
        JDBCType jdbcType = ColumnIndexStatsUtils.jdbcType(type);
        Object value = ShardOrganizerUtil.getValue(resultSet, type, columnName, jdbcType);
        return resultSet.wasNull() ? null : value;
    }

    private static Object getValue(ResultSet resultSet, Type type, String columnName, JDBCType jdbcType) throws SQLException {
        switch (jdbcType) {
            case BOOLEAN: {
                return resultSet.getBoolean(columnName);
            }
            case INTEGER: {
                return resultSet.getInt(columnName);
            }
            case BIGINT: {
                return resultSet.getLong(columnName);
            }
            case DOUBLE: {
                return resultSet.getDouble(columnName);
            }
            case VARBINARY: {
                return Slices.wrappedBuffer((byte[])resultSet.getBytes(columnName)).toStringUtf8();
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + type);
    }

    static OrganizationSet createOrganizationSet(long tableId, boolean tableSupportsDeltaDelete, Set<ShardIndexInfo> shardsToCompact, int priority) {
        Map uuidsMap = (Map)shardsToCompact.stream().collect(ImmutableMap.toImmutableMap(ShardIndexInfo::getShardUuid, ShardIndexInfo::getDeltaUuid));
        Set bucketNumber = shardsToCompact.stream().map(ShardIndexInfo::getBucketNumber).collect(Collectors.toSet());
        Preconditions.checkArgument((bucketNumber.size() == 1 ? 1 : 0) != 0);
        return new OrganizationSet(tableId, tableSupportsDeltaDelete, uuidsMap, (OptionalInt)Iterables.getOnlyElement(bucketNumber), priority);
    }
}

