/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.systemtables;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.metadata.ColumnMetadataRow;
import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.TableMetadataRow;
import com.facebook.presto.raptor.systemtables.PageListBuilder;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class TableMetadataSystemTable
implements SystemTable {
    private static final String TABLE_NAME = "table_name";
    private static final String SCHEMA_NAME = "table_schema";
    private final MetadataDao dao;
    private final ConnectorTableMetadata tableMetadata;

    @Inject
    public TableMetadataSystemTable(@ForMetadata IDBI dbi, TypeManager typeManager) {
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        Objects.requireNonNull(typeManager, "typeManager is null");
        Type arrayOfVarchar = typeManager.getType(TypeSignature.parseTypeSignature((String)"array<varchar>"));
        this.tableMetadata = new ConnectorTableMetadata(new SchemaTableName("system", "tables"), (List)ImmutableList.of((Object)new ColumnMetadata(SCHEMA_NAME, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(TABLE_NAME, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("temporal_column", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("ordering_columns", arrayOfVarchar), (Object)new ColumnMetadata("distribution_name", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("bucket_count", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("bucketing_columns", arrayOfVarchar), (Object)new ColumnMetadata("organized", (Type)BooleanType.BOOLEAN), (Object)new ColumnMetadata("table_supports_delta_delete", (Type)BooleanType.BOOLEAN)));
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(TableMetadataSystemTable.buildPages(this.dao, this.tableMetadata, constraint));
    }

    private static List<Page> buildPages(MetadataDao dao, ConnectorTableMetadata tableMetadata, TupleDomain<Integer> tupleDomain) {
        Map domainValues = (Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of());
        String schemaName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(tableMetadata, SCHEMA_NAME)));
        String tableName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(tableMetadata, TABLE_NAME)));
        PageListBuilder pageBuilder = new PageListBuilder(tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList()));
        List<TableMetadataRow> tableRows = dao.getTableMetadataRows(schemaName, tableName);
        PeekingIterator columnRowIterator = Iterators.peekingIterator(dao.getColumnMetadataRows(schemaName, tableName).iterator());
        for (TableMetadataRow tableRow : tableRows) {
            while (columnRowIterator.hasNext() && ((ColumnMetadataRow)columnRowIterator.peek()).getTableId() < tableRow.getTableId()) {
                columnRowIterator.next();
            }
            String temporalColumnName = null;
            TreeMap<Integer, String> sortColumnNames = new TreeMap<Integer, String>();
            TreeMap<Integer, String> bucketColumnNames = new TreeMap<Integer, String>();
            OptionalLong temporalColumnId = tableRow.getTemporalColumnId();
            while (columnRowIterator.hasNext() && ((ColumnMetadataRow)columnRowIterator.peek()).getTableId() == tableRow.getTableId()) {
                OptionalInt bucketOrdinalPosition;
                OptionalInt sortOrdinalPosition;
                ColumnMetadataRow columnRow = (ColumnMetadataRow)columnRowIterator.next();
                if (temporalColumnId.isPresent() && columnRow.getColumnId() == temporalColumnId.getAsLong()) {
                    temporalColumnName = columnRow.getColumnName();
                }
                if ((sortOrdinalPosition = columnRow.getSortOrdinalPosition()).isPresent()) {
                    sortColumnNames.put(sortOrdinalPosition.getAsInt(), columnRow.getColumnName());
                }
                if (!(bucketOrdinalPosition = columnRow.getBucketOrdinalPosition()).isPresent()) continue;
                bucketColumnNames.put(bucketOrdinalPosition.getAsInt(), columnRow.getColumnName());
            }
            pageBuilder.beginRow();
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)tableRow.getSchemaName()));
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)tableRow.getTableName()));
            if (temporalColumnId.isPresent()) {
                if (temporalColumnName == null) {
                    throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_CORRUPT_METADATA, String.format("Table ID %s has corrupt metadata (invalid temporal column ID)", tableRow.getTableId()));
                }
                VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)temporalColumnName));
            } else {
                pageBuilder.nextBlockBuilder().appendNull();
            }
            TableMetadataSystemTable.writeArray(pageBuilder.nextBlockBuilder(), sortColumnNames.values());
            Optional<String> distributionName = tableRow.getDistributionName();
            if (distributionName.isPresent()) {
                VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)distributionName.get()));
            } else {
                pageBuilder.nextBlockBuilder().appendNull();
            }
            OptionalInt bucketCount = tableRow.getBucketCount();
            if (bucketCount.isPresent()) {
                BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), (long)bucketCount.getAsInt());
            } else {
                pageBuilder.nextBlockBuilder().appendNull();
            }
            TableMetadataSystemTable.writeArray(pageBuilder.nextBlockBuilder(), bucketColumnNames.values());
            BooleanType.BOOLEAN.writeBoolean(pageBuilder.nextBlockBuilder(), tableRow.isOrganized());
            BooleanType.BOOLEAN.writeBoolean(pageBuilder.nextBlockBuilder(), tableRow.isTableSupportsDeltaDelete());
        }
        return pageBuilder.build();
    }

    private static void writeArray(BlockBuilder blockBuilder, Collection<String> values) {
        if (values.isEmpty()) {
            blockBuilder.appendNull();
        } else {
            BlockBuilder array = blockBuilder.beginBlockEntry();
            for (String value : values) {
                VarcharType.VARCHAR.writeSlice(array, Slices.utf8Slice((String)value));
            }
            blockBuilder.closeEntry();
        }
    }

    static int getColumnIndex(ConnectorTableMetadata tableMetadata, String columnName) {
        List columns = tableMetadata.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((ColumnMetadata)columns.get(i)).getName().equals(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column %s not found", columnName));
    }

    static String getStringValue(NullableValue value) {
        if (value == null || value.isNull()) {
            return null;
        }
        return ((Slice)value.getValue()).toStringUtf8();
    }
}

