/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.systemtables;

import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.TableStatsRow;
import com.facebook.presto.raptor.systemtables.PageListBuilder;
import com.facebook.presto.raptor.systemtables.TableMetadataSystemTable;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class TableStatsSystemTable
implements SystemTable {
    private static final String SCHEMA_NAME = "table_schema";
    private static final String TABLE_NAME = "table_name";
    private static final ConnectorTableMetadata METADATA = new ConnectorTableMetadata(new SchemaTableName("system", "table_stats"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("table_schema", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("table_name", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("create_time", (Type)TimestampType.TIMESTAMP)).add((Object)new ColumnMetadata("update_time", (Type)TimestampType.TIMESTAMP)).add((Object)new ColumnMetadata("table_version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("shard_count", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("delta_count", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("row_count", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("compressed_size", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("uncompressed_size", (Type)BigintType.BIGINT)).build());
    private final MetadataDao dao;

    @Inject
    public TableStatsSystemTable(@ForMetadata IDBI dbi) {
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(TableStatsSystemTable.buildPages(this.dao, constraint));
    }

    private static List<Page> buildPages(MetadataDao dao, TupleDomain<Integer> tupleDomain) {
        Map domainValues = (Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of());
        String schemaName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(METADATA, SCHEMA_NAME)));
        String tableName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(METADATA, TABLE_NAME)));
        PageListBuilder pageBuilder = new PageListBuilder(METADATA.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList()));
        for (TableStatsRow row : dao.getTableStatsRows(schemaName, tableName)) {
            pageBuilder.beginRow();
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)row.getSchemaName()));
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)row.getTableName()));
            TimestampType.TIMESTAMP.writeLong(pageBuilder.nextBlockBuilder(), row.getCreateTime());
            TimestampType.TIMESTAMP.writeLong(pageBuilder.nextBlockBuilder(), row.getUpdateTime());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getTableVersion());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getShardCount());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getDeltaCount());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getRowCount());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getCompressedSize());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getUncompressedSize());
        }
        return pageBuilder.build();
    }
}

