/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ThriftConnectorConfig {
    private DataSize maxResponseSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private int metadataRefreshThreads = 1;
    private int lookupRequestsConcurrency = 1;

    @NotNull
    @MinDataSize(value="1MB")
    @MaxDataSize(value="32MB")
    public DataSize getMaxResponseSize() {
        return this.maxResponseSize;
    }

    @Config(value="presto-thrift.max-response-size")
    public ThriftConnectorConfig setMaxResponseSize(DataSize maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMetadataRefreshThreads() {
        return this.metadataRefreshThreads;
    }

    @Config(value="presto-thrift.metadata-refresh-threads")
    public ThriftConnectorConfig setMetadataRefreshThreads(int metadataRefreshThreads) {
        this.metadataRefreshThreads = metadataRefreshThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getLookupRequestsConcurrency() {
        return this.lookupRequestsConcurrency;
    }

    @Config(value="presto-thrift.lookup-requests-concurrency")
    public ThriftConnectorConfig setLookupRequestsConcurrency(int lookupRequestsConcurrency) {
        this.lookupRequestsConcurrency = lookupRequestsConcurrency;
        return this;
    }
}

