/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.connector.thrift.ThriftColumnHandle;
import com.facebook.presto.connector.thrift.ThriftConnectorStats;
import com.facebook.presto.connector.thrift.ThriftIndexHandle;
import com.facebook.presto.connector.thrift.api.PrestoThriftId;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableToken;
import com.facebook.presto.connector.thrift.api.PrestoThriftPageResult;
import com.facebook.presto.connector.thrift.api.PrestoThriftSchemaTableName;
import com.facebook.presto.connector.thrift.api.PrestoThriftService;
import com.facebook.presto.connector.thrift.api.PrestoThriftSplit;
import com.facebook.presto.connector.thrift.api.PrestoThriftSplitBatch;
import com.facebook.presto.connector.thrift.api.PrestoThriftTupleDomain;
import com.facebook.presto.connector.thrift.util.ThriftExceptions;
import com.facebook.presto.connector.thrift.util.TupleDomainConversion;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ThriftIndexPageSource
implements ConnectorPageSource {
    private static final int MAX_SPLIT_COUNT = 10000000;
    private final DriftClient<PrestoThriftService> client;
    private final Map<String, String> thriftHeaders;
    private final PrestoThriftSchemaTableName schemaTableName;
    private final List<String> lookupColumnNames;
    private final List<String> outputColumnNames;
    private final List<Type> outputColumnTypes;
    private final PrestoThriftTupleDomain outputConstraint;
    private final PrestoThriftPageResult keys;
    private final long maxBytesPerResponse;
    private final int lookupRequestsConcurrency;
    private final AtomicLong readTimeNanos = new AtomicLong(0L);
    private long completedBytes;
    private long completedPositions;
    private CompletableFuture<?> statusFuture;
    private ListenableFuture<PrestoThriftSplitBatch> splitFuture;
    private ListenableFuture<PrestoThriftPageResult> dataSignalFuture;
    private final List<PrestoThriftSplit> splits = new ArrayList<PrestoThriftSplit>();
    private final Queue<ListenableFuture<PrestoThriftPageResult>> dataRequests = new LinkedList<ListenableFuture<PrestoThriftPageResult>>();
    private final Map<ListenableFuture<PrestoThriftPageResult>, RunningSplitContext> contexts;
    private final ThriftConnectorStats stats;
    private int splitIndex;
    private boolean haveSplits;
    private boolean finished;

    public ThriftIndexPageSource(DriftClient<PrestoThriftService> client, Map<String, String> thriftHeaders, ThriftConnectorStats stats, ThriftIndexHandle indexHandle, List<ColumnHandle> lookupColumns, List<ColumnHandle> outputColumns, RecordSet keys, long maxBytesPerResponse, int lookupRequestsConcurrency) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaders = Objects.requireNonNull(thriftHeaders, "thriftHeaders is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(indexHandle, "indexHandle is null");
        this.schemaTableName = new PrestoThriftSchemaTableName(indexHandle.getSchemaTableName());
        this.outputConstraint = TupleDomainConversion.tupleDomainToThriftTupleDomain(indexHandle.getTupleDomain());
        Objects.requireNonNull(lookupColumns, "lookupColumns is null");
        this.lookupColumnNames = (List)lookupColumns.stream().map(ThriftColumnHandle.class::cast).map(ThriftColumnHandle::getColumnName).collect(ImmutableList.toImmutableList());
        Objects.requireNonNull(outputColumns, "outputColumns is null");
        ImmutableList.Builder outputColumnNames = new ImmutableList.Builder();
        ImmutableList.Builder outputColumnTypes = new ImmutableList.Builder();
        for (ColumnHandle columnHandle : outputColumns) {
            ThriftColumnHandle thriftColumnHandle = (ThriftColumnHandle)columnHandle;
            outputColumnNames.add((Object)thriftColumnHandle.getColumnName());
            outputColumnTypes.add((Object)thriftColumnHandle.getColumnType());
        }
        this.outputColumnNames = outputColumnNames.build();
        this.outputColumnTypes = outputColumnTypes.build();
        this.keys = PrestoThriftPageResult.fromRecordSet((RecordSet)Objects.requireNonNull(keys, "keys is null"));
        Preconditions.checkArgument((maxBytesPerResponse > 0L ? 1 : 0) != 0, (Object)"maxBytesPerResponse is zero or negative");
        this.maxBytesPerResponse = maxBytesPerResponse;
        Preconditions.checkArgument((lookupRequestsConcurrency >= 1 ? 1 : 0) != 0, (Object)"lookupRequestsConcurrency is less than one");
        this.lookupRequestsConcurrency = lookupRequestsConcurrency;
        this.contexts = new HashMap<ListenableFuture<PrestoThriftPageResult>, RunningSplitContext>(lookupRequestsConcurrency);
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public CompletableFuture<?> isBlocked() {
        return this.statusFuture == null ? NOT_BLOCKED : this.statusFuture;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        if (!this.loadAllSplits()) {
            return null;
        }
        if (this.dataSignalFuture == null) {
            Preconditions.checkState((this.contexts.isEmpty() && this.dataRequests.isEmpty() ? 1 : 0) != 0, (Object)"some splits are already started");
            if (this.splits.isEmpty()) {
                this.finished = true;
                return null;
            }
            for (int i = 0; i < Math.min(this.lookupRequestsConcurrency, this.splits.size()); ++i) {
                this.startDataFetchForNextSplit();
            }
            this.updateSignalAndStatusFutures();
        }
        if (!this.dataSignalFuture.isDone()) {
            return null;
        }
        ListenableFuture<PrestoThriftPageResult> resultFuture = this.getAndRemoveNextCompletedRequest();
        RunningSplitContext resultContext = this.contexts.remove(resultFuture);
        Preconditions.checkState((resultContext != null ? 1 : 0) != 0, (Object)"no associated context for the request");
        PrestoThriftPageResult pageResult = (PrestoThriftPageResult)MoreFutures.getFutureValue(resultFuture);
        Page page = pageResult.toPage(this.outputColumnTypes);
        if (page != null) {
            long pageSize = page.getSizeInBytes();
            this.completedBytes += pageSize;
            this.completedPositions += (long)page.getPositionCount();
            this.stats.addIndexPageSize(pageSize);
        } else {
            this.stats.addIndexPageSize(0L);
        }
        if (pageResult.getNextToken() != null) {
            this.sendDataRequest(resultContext, pageResult.getNextToken());
            this.updateSignalAndStatusFutures();
            return page;
        }
        if (this.splitIndex < this.splits.size()) {
            this.startDataFetchForNextSplit();
            this.updateSignalAndStatusFutures();
        } else if (!this.dataRequests.isEmpty()) {
            this.updateSignalAndStatusFutures();
        } else {
            this.dataSignalFuture = null;
            this.statusFuture = null;
            this.finished = true;
        }
        return page;
    }

    private boolean loadAllSplits() {
        if (this.haveSplits) {
            return true;
        }
        if (this.splitFuture == null) {
            this.splitFuture = this.sendSplitRequest(null);
            this.statusFuture = MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(this.splitFuture));
        }
        if (!this.splitFuture.isDone()) {
            return false;
        }
        PrestoThriftSplitBatch batch = (PrestoThriftSplitBatch)MoreFutures.getFutureValue(this.splitFuture);
        this.splits.addAll(batch.getSplits());
        if (batch.getNextToken() != null) {
            this.splitFuture = this.sendSplitRequest(batch.getNextToken());
            this.statusFuture = MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(this.splitFuture));
            return false;
        }
        this.splitFuture = null;
        this.statusFuture = null;
        this.haveSplits = true;
        return true;
    }

    private void updateSignalAndStatusFutures() {
        this.dataSignalFuture = MoreFutures.whenAnyComplete(this.dataRequests);
        this.statusFuture = MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(this.dataSignalFuture));
    }

    private void startDataFetchForNextSplit() {
        PrestoThriftSplit split = this.splits.get(this.splitIndex);
        ++this.splitIndex;
        RunningSplitContext context = new RunningSplitContext(this.openClient(split), split);
        this.sendDataRequest(context, null);
    }

    private ListenableFuture<PrestoThriftSplitBatch> sendSplitRequest(@Nullable PrestoThriftId nextToken) {
        long start = System.nanoTime();
        ListenableFuture future = ((PrestoThriftService)this.client.get(this.thriftHeaders)).getIndexSplits(this.schemaTableName, this.lookupColumnNames, this.outputColumnNames, this.keys, this.outputConstraint, 10000000, new PrestoThriftNullableToken(nextToken));
        future = ThriftExceptions.catchingThriftException(future);
        future.addListener(() -> this.readTimeNanos.addAndGet(System.nanoTime() - start), MoreExecutors.directExecutor());
        return future;
    }

    private void sendDataRequest(RunningSplitContext context, @Nullable PrestoThriftId nextToken) {
        long start = System.nanoTime();
        ListenableFuture future = context.getClient().getRows(context.getSplit().getSplitId(), this.outputColumnNames, this.maxBytesPerResponse, new PrestoThriftNullableToken(nextToken));
        future = ThriftExceptions.catchingThriftException(future);
        future.addListener(() -> this.readTimeNanos.addAndGet(System.nanoTime() - start), MoreExecutors.directExecutor());
        this.dataRequests.add(future);
        this.contexts.put(future, context);
    }

    private PrestoThriftService openClient(PrestoThriftSplit split) {
        if (split.getHosts().isEmpty()) {
            return (PrestoThriftService)this.client.get(this.thriftHeaders);
        }
        String hosts = split.getHosts().stream().map(host -> host.toHostAddress().toString()).collect(Collectors.joining(","));
        return (PrestoThriftService)this.client.get(Optional.of(hosts), this.thriftHeaders);
    }

    public void close() {
        ThriftIndexPageSource.cancelQuietly(this.splitFuture);
        this.dataRequests.forEach(ThriftIndexPageSource::cancelQuietly);
    }

    private ListenableFuture<PrestoThriftPageResult> getAndRemoveNextCompletedRequest() {
        Iterator iterator = this.dataRequests.iterator();
        while (iterator.hasNext()) {
            ListenableFuture future = (ListenableFuture)iterator.next();
            if (!future.isDone()) continue;
            iterator.remove();
            return future;
        }
        throw new IllegalStateException("No completed splits in the queue");
    }

    private static void cancelQuietly(Future<?> future) {
        if (future != null) {
            future.cancel(true);
        }
    }

    private static final class RunningSplitContext {
        private final PrestoThriftService client;
        private final PrestoThriftSplit split;

        public RunningSplitContext(PrestoThriftService client, PrestoThriftSplit split) {
            this.client = client;
            this.split = split;
        }

        public PrestoThriftService getClient() {
            return this.client;
        }

        public PrestoThriftSplit getSplit() {
            return this.split;
        }
    }
}

