/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.connector.thrift.ThriftColumnHandle;
import com.facebook.presto.connector.thrift.ThriftConnectorSplit;
import com.facebook.presto.connector.thrift.ThriftConnectorStats;
import com.facebook.presto.connector.thrift.api.PrestoThriftId;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableToken;
import com.facebook.presto.connector.thrift.api.PrestoThriftPageResult;
import com.facebook.presto.connector.thrift.api.PrestoThriftService;
import com.facebook.presto.connector.thrift.util.ThriftExceptions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class ThriftPageSource
implements ConnectorPageSource {
    private final PrestoThriftId splitId;
    private final PrestoThriftService client;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final long maxBytesPerResponse;
    private final AtomicLong readTimeNanos = new AtomicLong(0L);
    private PrestoThriftId nextToken;
    private boolean firstCall = true;
    private CompletableFuture<PrestoThriftPageResult> future;
    private final ThriftConnectorStats stats;
    private long completedBytes;
    private long completedPositions;

    public ThriftPageSource(DriftClient<PrestoThriftService> client, Map<String, String> thriftHeader, ThriftConnectorSplit split, List<ColumnHandle> columns, ThriftConnectorStats stats, long maxBytesPerResponse) {
        Objects.requireNonNull(columns, "columns is null");
        ImmutableList.Builder columnNames = new ImmutableList.Builder();
        ImmutableList.Builder columnTypes = new ImmutableList.Builder();
        for (ColumnHandle columnHandle : columns) {
            ThriftColumnHandle thriftColumnHandle = (ThriftColumnHandle)columnHandle;
            columnNames.add((Object)thriftColumnHandle.getColumnName());
            columnTypes.add((Object)thriftColumnHandle.getColumnType());
        }
        this.columnNames = columnNames.build();
        this.columnTypes = columnTypes.build();
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Preconditions.checkArgument((maxBytesPerResponse > 0L ? 1 : 0) != 0, (Object)"maxBytesPerResponse is zero or negative");
        this.maxBytesPerResponse = maxBytesPerResponse;
        Objects.requireNonNull(split, "split is null");
        this.splitId = split.getSplitId();
        Objects.requireNonNull(client, "client is null");
        if (split.getAddresses().isEmpty()) {
            this.client = (PrestoThriftService)client.get(thriftHeader);
        } else {
            String hosts = split.getAddresses().stream().map(HostAddress::toString).collect(Collectors.joining(","));
            this.client = (PrestoThriftService)client.get(Optional.of(hosts), thriftHeader);
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public boolean isFinished() {
        return !this.firstCall && !ThriftPageSource.canGetMoreData(this.nextToken);
    }

    public Page getNextPage() {
        if (this.future == null) {
            if (this.firstCall || ThriftPageSource.canGetMoreData(this.nextToken)) {
                this.future = this.sendDataRequestInternal();
            }
            return null;
        }
        if (!this.future.isDone()) {
            return null;
        }
        Page result = this.processBatch((PrestoThriftPageResult)MoreFutures.getFutureValue(this.future));
        this.future = ThriftPageSource.canGetMoreData(this.nextToken) ? this.sendDataRequestInternal() : null;
        return result;
    }

    private static boolean canGetMoreData(PrestoThriftId nextToken) {
        return nextToken != null;
    }

    private CompletableFuture<PrestoThriftPageResult> sendDataRequestInternal() {
        long start = System.nanoTime();
        ListenableFuture rowsBatchFuture = this.client.getRows(this.splitId, this.columnNames, this.maxBytesPerResponse, new PrestoThriftNullableToken(this.nextToken));
        rowsBatchFuture = ThriftExceptions.catchingThriftException(rowsBatchFuture);
        rowsBatchFuture.addListener(() -> this.readTimeNanos.addAndGet(System.nanoTime() - start), MoreExecutors.directExecutor());
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(rowsBatchFuture));
    }

    private Page processBatch(PrestoThriftPageResult rowsBatch) {
        this.firstCall = false;
        this.nextToken = rowsBatch.getNextToken();
        Page page = rowsBatch.toPage(this.columnTypes);
        if (page != null) {
            long pageSize = page.getSizeInBytes();
            this.completedBytes += pageSize;
            this.completedPositions += (long)page.getPositionCount();
            this.stats.addScanPageSize(pageSize);
        } else {
            this.stats.addScanPageSize(0L);
        }
        return page;
    }

    public CompletableFuture<?> isBlocked() {
        return this.future == null ? NOT_BLOCKED : this.future;
    }

    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

