/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.connector.thrift.ThriftColumnHandle;
import com.facebook.presto.connector.thrift.ThriftConnectorSplit;
import com.facebook.presto.connector.thrift.ThriftHeaderProvider;
import com.facebook.presto.connector.thrift.ThriftTableLayoutHandle;
import com.facebook.presto.connector.thrift.api.PrestoThriftHostAddress;
import com.facebook.presto.connector.thrift.api.PrestoThriftId;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableColumnSet;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableToken;
import com.facebook.presto.connector.thrift.api.PrestoThriftSchemaTableName;
import com.facebook.presto.connector.thrift.api.PrestoThriftService;
import com.facebook.presto.connector.thrift.api.PrestoThriftSplit;
import com.facebook.presto.connector.thrift.api.PrestoThriftTupleDomain;
import com.facebook.presto.connector.thrift.util.ThriftExceptions;
import com.facebook.presto.connector.thrift.util.TupleDomainConversion;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;

public class ThriftSplitManager
implements ConnectorSplitManager {
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;

    @Inject
    public ThriftSplitManager(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        ThriftTableLayoutHandle layoutHandle = (ThriftTableLayoutHandle)layout;
        return new ThriftSplitSource((PrestoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session)), new PrestoThriftSchemaTableName(layoutHandle.getSchemaName(), layoutHandle.getTableName()), layoutHandle.getColumns().map(ThriftSplitManager::columnNames), TupleDomainConversion.tupleDomainToThriftTupleDomain(layoutHandle.getConstraint()));
    }

    private static Set<String> columnNames(Set<ColumnHandle> columns) {
        return (Set)columns.stream().map(ThriftColumnHandle.class::cast).map(ThriftColumnHandle::getColumnName).collect(ImmutableSet.toImmutableSet());
    }

    @NotThreadSafe
    private static class ThriftSplitSource
    implements ConnectorSplitSource {
        private final PrestoThriftService client;
        private final PrestoThriftSchemaTableName schemaTableName;
        private final Optional<Set<String>> columnNames;
        private final PrestoThriftTupleDomain constraint;
        private final AtomicBoolean hasMoreData;
        private final AtomicReference<PrestoThriftId> nextToken;
        private final AtomicReference<Future<?>> future;

        public ThriftSplitSource(PrestoThriftService client, PrestoThriftSchemaTableName schemaTableName, Optional<Set<String>> columnNames, PrestoThriftTupleDomain constraint) {
            this.client = Objects.requireNonNull(client, "client is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
            this.constraint = Objects.requireNonNull(constraint, "constraint is null");
            this.nextToken = new AtomicReference<Object>(null);
            this.hasMoreData = new AtomicBoolean(true);
            this.future = new AtomicReference<Object>(null);
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            Preconditions.checkArgument((boolean)partitionHandle.equals((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED), (Object)"partitionHandle must be NOT_PARTITIONED");
            Preconditions.checkState((this.future.get() == null || this.future.get().isDone() ? 1 : 0) != 0, (Object)"previous batch not completed");
            Preconditions.checkState((boolean)this.hasMoreData.get(), (Object)"this method cannot be invoked when there's no more data");
            PrestoThriftId currentToken = this.nextToken.get();
            ListenableFuture splitsFuture = this.client.getSplits(this.schemaTableName, new PrestoThriftNullableColumnSet((Set)this.columnNames.orElse(null)), this.constraint, maxSize, new PrestoThriftNullableToken(currentToken));
            ListenableFuture resultFuture = Futures.transform((ListenableFuture)splitsFuture, batch -> {
                Objects.requireNonNull(batch, "batch is null");
                List splits = (List)batch.getSplits().stream().map(ThriftSplitSource::toConnectorSplit).collect(ImmutableList.toImmutableList());
                Preconditions.checkState((boolean)this.nextToken.compareAndSet(currentToken, batch.getNextToken()));
                Preconditions.checkState((boolean)this.hasMoreData.compareAndSet(true, this.nextToken.get() != null));
                return new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished());
            }, (Executor)MoreExecutors.directExecutor());
            resultFuture = ThriftExceptions.catchingThriftException(resultFuture);
            this.future.set((Future<?>)resultFuture);
            return MoreFutures.toCompletableFuture(resultFuture);
        }

        public boolean isFinished() {
            return !this.hasMoreData.get();
        }

        public void close() {
            Future currentFuture = this.future.getAndSet(null);
            if (currentFuture != null) {
                currentFuture.cancel(true);
            }
        }

        private static ThriftConnectorSplit toConnectorSplit(PrestoThriftSplit thriftSplit) {
            return new ThriftConnectorSplit(thriftSplit.getSplitId(), ThriftSplitSource.toHostAddressList(thriftSplit.getHosts()));
        }

        private static List<HostAddress> toHostAddressList(List<PrestoThriftHostAddress> hosts) {
            return (List)hosts.stream().map(PrestoThriftHostAddress::toHostAddress).collect(ImmutableList.toImmutableList());
        }
    }
}

