/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.decoder.DecoderModule;
import com.facebook.presto.kafka.KafkaConnector;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConsumerManager;
import com.facebook.presto.kafka.KafkaMetadata;
import com.facebook.presto.kafka.KafkaRecordSetProvider;
import com.facebook.presto.kafka.KafkaSplitManager;
import com.facebook.presto.kafka.KafkaStaticServerset;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;
import javax.inject.Inject;

public class KafkaConnectorModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        binder.bind(KafkaConnector.class).in(Scopes.SINGLETON);
        binder.bind(KafkaStaticServerset.class).in(Scopes.SINGLETON);
        binder.bind(KafkaMetadata.class).in(Scopes.SINGLETON);
        binder.bind(KafkaSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(KafkaRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(KafkaConsumerManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(KafkaConnectorConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(KafkaTopicDescription.class);
        binder.install((Module)new DecoderModule());
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
        }
    }
}

