/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public enum KafkaInternalFieldDescription {
    PARTITION_ID_FIELD("_partition_id", (Type)BigintType.BIGINT, "Partition Id"),
    PARTITION_OFFSET_FIELD("_partition_offset", (Type)BigintType.BIGINT, "Offset for the message within the partition"),
    MESSAGE_CORRUPT_FIELD("_message_corrupt", (Type)BooleanType.BOOLEAN, "Message data is corrupt"),
    MESSAGE_FIELD("_message", (Type)VarcharType.createUnboundedVarcharType(), "Message text"),
    MESSAGE_LENGTH_FIELD("_message_length", (Type)BigintType.BIGINT, "Total number of message bytes"),
    KEY_CORRUPT_FIELD("_key_corrupt", (Type)BooleanType.BOOLEAN, "Key data is corrupt"),
    KEY_FIELD("_key", (Type)VarcharType.createUnboundedVarcharType(), "Key text"),
    KEY_LENGTH_FIELD("_key_length", (Type)BigintType.BIGINT, "Total number of key bytes"),
    OFFSET_TIMESTAMP_FIELD("_timestamp", (Type)BigintType.BIGINT, "Offset Timestamp");

    private static final Map<String, KafkaInternalFieldDescription> BY_COLUMN_NAME;
    private final String columnName;
    private final Type type;
    private final String comment;

    public static KafkaInternalFieldDescription forColumnName(String columnName) {
        KafkaInternalFieldDescription description = BY_COLUMN_NAME.get(columnName);
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (String)"Unknown internal column name %s", (Object)columnName);
        return description;
    }

    private KafkaInternalFieldDescription(String columnName, Type type, String comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)columnName) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.columnName = columnName;
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getType() {
        return this.type;
    }

    KafkaColumnHandle getColumnHandle(String connectorId, int index, boolean hidden) {
        return new KafkaColumnHandle(connectorId, index, this.getColumnName(), this.getType(), null, null, null, false, hidden, true);
    }

    ColumnMetadata getColumnMetadata(boolean hidden) {
        return new ColumnMetadata(this.columnName, this.type, this.comment, hidden);
    }

    static {
        BY_COLUMN_NAME = (Map)Arrays.stream(KafkaInternalFieldDescription.values()).collect(ImmutableMap.toImmutableMap(KafkaInternalFieldDescription::getColumnName, Function.identity()));
    }
}

