/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.FieldValueProviders;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaConsumerManager;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;

public class KafkaRecordSet
implements RecordSet {
    private static final Logger log = Logger.get(KafkaRecordSet.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int POLL_TIMEOUT = 500;
    private final KafkaSplit split;
    private final KafkaConsumerManager consumerManager;
    private final RowDecoder keyDecoder;
    private final RowDecoder messageDecoder;
    private final List<KafkaColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    KafkaRecordSet(KafkaSplit split, KafkaConsumerManager consumerManager, List<KafkaColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder messageDecoder) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "rowDecoder is null");
        this.messageDecoder = Objects.requireNonNull(messageDecoder, "rowDecoder is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (DecoderColumnHandle decoderColumnHandle : columnHandles) {
            typeBuilder.add((Object)decoderColumnHandle.getType());
        }
        this.columnTypes = typeBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new KafkaRecordCursor();
    }

    public class KafkaRecordCursor
    implements RecordCursor {
        private long totalBytes;
        private long totalMessages;
        private long cursorOffset;
        private Iterator<ConsumerRecord<ByteBuffer, ByteBuffer>> messageAndOffsetIterator;
        private final AtomicBoolean reported;
        private KafkaConsumer<ByteBuffer, ByteBuffer> consumer;
        private final FieldValueProvider[] currentRowValues;

        KafkaRecordCursor() {
            this.cursorOffset = KafkaRecordSet.this.split.getStart();
            this.reported = new AtomicBoolean();
            this.currentRowValues = new FieldValueProvider[KafkaRecordSet.this.columnHandles.size()];
        }

        public long getCompletedBytes() {
            return this.totalBytes;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return ((KafkaColumnHandle)KafkaRecordSet.this.columnHandles.get(field)).getType();
        }

        public boolean advanceNextPosition() {
            while (this.cursorOffset < KafkaRecordSet.this.split.getEnd()) {
                this.openFetchRequest();
                while (this.messageAndOffsetIterator.hasNext()) {
                    ConsumerRecord<ByteBuffer, ByteBuffer> currentMessageAndOffset = this.messageAndOffsetIterator.next();
                    long messageOffset = currentMessageAndOffset.offset();
                    if (messageOffset >= KafkaRecordSet.this.split.getEnd()) {
                        return this.endOfData();
                    }
                    if (messageOffset < this.cursorOffset) continue;
                    return this.nextRow(currentMessageAndOffset);
                }
                this.messageAndOffsetIterator = null;
            }
            return this.endOfData();
        }

        private boolean endOfData() {
            if (!this.reported.getAndSet(true)) {
                log.debug("Found a total of %d messages with %d bytes (%d messages expected). Last Offset: %d (%d, %d)", new Object[]{this.totalMessages, this.totalBytes, KafkaRecordSet.this.split.getEnd() - KafkaRecordSet.this.split.getStart(), this.cursorOffset, KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd()});
            }
            return false;
        }

        private boolean nextRow(ConsumerRecord<ByteBuffer, ByteBuffer> messageAndOffset) {
            ByteBuffer message;
            this.cursorOffset = messageAndOffset.offset() + 1L;
            this.totalBytes += (long)messageAndOffset.serializedValueSize();
            ++this.totalMessages;
            byte[] keyData = EMPTY_BYTE_ARRAY;
            byte[] messageData = EMPTY_BYTE_ARRAY;
            ByteBuffer key = (ByteBuffer)messageAndOffset.key();
            if (key != null) {
                keyData = new byte[key.remaining()];
                key.get(keyData);
            }
            if ((message = (ByteBuffer)messageAndOffset.value()) != null) {
                messageData = new byte[message.remaining()];
                message.get(messageData);
            }
            long timeStamp = messageAndOffset.timestamp();
            HashMap<DecoderColumnHandle, FieldValueProvider> currentRowValuesMap = new HashMap<DecoderColumnHandle, FieldValueProvider>();
            Optional decodedKey = KafkaRecordSet.this.keyDecoder.decodeRow(keyData, null);
            Optional decodedValue = KafkaRecordSet.this.messageDecoder.decodeRow(messageData, null);
            block11: for (DecoderColumnHandle columnHandle : KafkaRecordSet.this.columnHandles) {
                if (!columnHandle.isInternal()) continue;
                KafkaInternalFieldDescription fieldDescription = KafkaInternalFieldDescription.forColumnName(columnHandle.getName());
                switch (fieldDescription) {
                    case PARTITION_OFFSET_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)messageAndOffset.offset()));
                        continue block11;
                    }
                    case MESSAGE_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.bytesValueProvider((byte[])messageData));
                        continue block11;
                    }
                    case MESSAGE_LENGTH_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)messageData.length));
                        continue block11;
                    }
                    case KEY_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.bytesValueProvider((byte[])keyData));
                        continue block11;
                    }
                    case KEY_LENGTH_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)keyData.length));
                        continue block11;
                    }
                    case KEY_CORRUPT_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.booleanValueProvider((!decodedKey.isPresent() ? 1 : 0) != 0));
                        continue block11;
                    }
                    case MESSAGE_CORRUPT_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.booleanValueProvider((!decodedValue.isPresent() ? 1 : 0) != 0));
                        continue block11;
                    }
                    case PARTITION_ID_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)KafkaRecordSet.this.split.getPartitionId()));
                        continue block11;
                    }
                    case OFFSET_TIMESTAMP_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)timeStamp));
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("unknown internal field " + (Object)((Object)fieldDescription));
            }
            decodedKey.ifPresent(currentRowValuesMap::putAll);
            decodedValue.ifPresent(currentRowValuesMap::putAll);
            for (int i = 0; i < KafkaRecordSet.this.columnHandles.size(); ++i) {
                DecoderColumnHandle columnHandle;
                columnHandle = (ColumnHandle)KafkaRecordSet.this.columnHandles.get(i);
                this.currentRowValues[i] = (FieldValueProvider)currentRowValuesMap.get(columnHandle);
            }
            return true;
        }

        public boolean getBoolean(int field) {
            return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
        }

        public long getLong(int field) {
            return this.getFieldValueProvider(field, Long.TYPE).getLong();
        }

        public double getDouble(int field) {
            return this.getFieldValueProvider(field, Double.TYPE).getDouble();
        }

        public Slice getSlice(int field) {
            return this.getFieldValueProvider(field, Slice.class).getSlice();
        }

        public Object getObject(int field) {
            return this.getFieldValueProvider(field, Block.class).getBlock();
        }

        public boolean isNull(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return this.currentRowValues[field] == null || this.currentRowValues[field].isNull();
        }

        private FieldValueProvider getFieldValueProvider(int field, Class<?> expectedType) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, expectedType);
            return this.currentRowValues[field];
        }

        private void checkFieldType(int field, Class<?> expected) {
            Class actual = this.getType(field).getJavaType();
            Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
        }

        public void close() {
            if (this.consumer != null) {
                this.consumer.close();
            }
        }

        private void openFetchRequest() {
            try {
                if (this.messageAndOffsetIterator == null) {
                    String threadName = Thread.currentThread().getName();
                    if (this.consumer == null) {
                        this.consumer = KafkaRecordSet.this.consumerManager.createConsumer(threadName, KafkaRecordSet.this.split.getLeader());
                    }
                    TopicPartition topicPartition = new TopicPartition(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId());
                    this.consumer.assign((Collection)ImmutableList.of((Object)topicPartition));
                    this.consumer.seek(topicPartition, this.cursorOffset);
                    ConsumerRecords records = this.consumer.poll(500L);
                    this.messageAndOffsetIterator = records.records(topicPartition).iterator();
                }
            }
            catch (Exception e) {
                if (e instanceof PrestoException) {
                    throw e;
                }
                throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, String.format("Cannot read data from topic '%s', partition '%s', startOffset %s, endOffset %s, leader %s ", KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId(), KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd(), KafkaRecordSet.this.split.getLeader()), (Throwable)e);
            }
        }
    }
}

