/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class KafkaSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String topicName;
    private final String keyDataFormat;
    private final String messageDataFormat;
    private final Optional<String> keyDataSchemaContents;
    private final Optional<String> messageDataSchemaContents;
    private final int partitionId;
    private final long start;
    private final long end;
    private final HostAddress leader;

    @JsonCreator
    public KafkaSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="keyDataSchemaContents") Optional<String> keyDataSchemaContents, @JsonProperty(value="messageDataSchemaContents") Optional<String> messageDataSchemaContents, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="leader") HostAddress leader) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "dataFormat is null");
        this.messageDataFormat = Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        this.keyDataSchemaContents = keyDataSchemaContents;
        this.messageDataSchemaContents = messageDataSchemaContents;
        this.partitionId = partitionId;
        this.start = start;
        this.end = end;
        this.leader = Objects.requireNonNull(leader, "leader address is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getEnd() {
        return this.end;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public Optional<String> getKeyDataSchemaContents() {
        return this.keyDataSchemaContents;
    }

    @JsonProperty
    public Optional<String> getMessageDataSchemaContents() {
        return this.messageDataSchemaContents;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public HostAddress getLeader() {
        return this.leader;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return ImmutableList.of((Object)this.leader);
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("topicName", (Object)this.topicName).add("keyDataFormat", (Object)this.keyDataFormat).add("messageDataFormat", (Object)this.messageDataFormat).add("keyDataSchemaContents", this.keyDataSchemaContents).add("messageDataSchemaContents", this.messageDataSchemaContents).add("partitionId", this.partitionId).add("start", this.start).add("end", this.end).add("leader", (Object)this.leader).toString();
    }
}

