/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public class KafkaStaticServerset {
    private final List<HostAddress> nodes;

    @Inject
    public KafkaStaticServerset(KafkaConnectorConfig config) {
        Objects.requireNonNull(config.getNodes(), "nodes is null");
        Preconditions.checkArgument((!config.getNodes().isEmpty() ? 1 : 0) != 0, (Object)"nodes must specify at least one URI");
        this.nodes = config.getNodes();
    }

    public HostAddress selectRandomServer() {
        return KafkaStaticServerset.selectRandom(this.nodes);
    }

    private static <T> T selectRandom(Iterable<T> iterable) {
        ImmutableList list = ImmutableList.copyOf(iterable);
        return (T)list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }
}

