/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.Symbol;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import xerial.core.log.LogLevel;
import xerial.core.log.LogWriter;
import xerial.core.log.Logger;
import xerial.larray.BitEncoder$;
import xerial.larray.LArray$;
import xerial.larray.LBitArray;
import xerial.larray.LBuilder;
import xerial.larray.LBuilder$class;
import xerial.larray.LIterator;
import xerial.larray.LLongArray;
import xerial.larray.LSeq;
import xerial.larray.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u0014\"ji\u0006\u0013(/Y=Ck&dG-\u001a:\u000b\u0005\r!\u0011A\u00027beJ\f\u0017PC\u0001\u0006\u0003\u0019AXM]5bY\u000e\u00011\u0003\u0002\u0001\t!u\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0005#I!\"$D\u0001\u0003\u0013\t\u0019\"A\u0001\u0005M\u0005VLG\u000eZ3s!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u001d\u0011un\u001c7fC:\u0004\"!E\u000e\n\u0005q\u0011!!\u0003'CSR\f%O]1z!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0002m_\u001eT!A\t\u0003\u0002\t\r|'/Z\u0005\u0003I}\u0011a\u0001T8hO\u0016\u0014\b\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\bF\u0001)!\t\t\u0002\u0001C\u0003+\u0001\u0011\u00051&A\u0006fY\u0016lWM\u001c;TSj,W#\u0001\u0017\u0011\u0005Ui\u0013B\u0001\u0018\u0017\u0005\u001dqu\u000e\u001e5j]\u001eD\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011B\u0019\u0002\u000b\u0015dW-\\:\u0016\u0003I\u0002\"!E\u001a\n\u0005Q\u0012!A\u0003'M_:<\u0017I\u001d:bs\"Ia\u0007\u0001a\u0001\u0002\u0004%IaN\u0001\nK2,Wn]0%KF$\"\u0001O\u001e\u0011\u0005UI\u0014B\u0001\u001e\u0017\u0005\u0011)f.\u001b;\t\u000fq*\u0014\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u00033\u0003\u0019)G.Z7tA!9\u0001\t\u0001a\u0001\n\u0013\t\u0015\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003\t\u0003\"!F\"\n\u0005\u00113\"\u0001\u0002'p]\u001eDqA\u0012\u0001A\u0002\u0013%q)\u0001\u0007dCB\f7-\u001b;z?\u0012*\u0017\u000f\u0006\u00029\u0011\"9A(RA\u0001\u0002\u0004\u0011\u0005B\u0002&\u0001A\u0003&!)A\u0005dCB\f7-\u001b;zA!9A\n\u0001a\u0001\n\u0013\t\u0015a\u00028v[\nKGo\u001d\u0005\b\u001d\u0002\u0001\r\u0011\"\u0003P\u0003-qW/\u001c\"jiN|F%Z9\u0015\u0005a\u0002\u0006b\u0002\u001fN\u0003\u0003\u0005\rA\u0011\u0005\u0007%\u0002\u0001\u000b\u0015\u0002\"\u0002\u00119,XNQ5ug\u0002BQ\u0001\u0016\u0001\u0005\u0012U\u000bq!\\6BeJ\f\u0017\u0010\u0006\u00023-\")qk\u0015a\u0001\u0005\u0006!1/\u001b>f\u0011\u0015I\u0006\u0001\"\u0001[\u0003!\u0019\u0018N_3IS:$HC\u0001\u001d\\\u0011\u00159\u0006\f1\u0001C\u0011\u0015i\u0006\u0001\"\u0005_\u0003))gn];sKNK'0\u001a\u000b\u0003q}CQa\u0016/A\u0002\tCQ!\u0019\u0001\u0005\u0012\t\faA]3tSj,GC\u0001\u001dd\u0011\u00159\u0006\r1\u0001C\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u0015\u0019G.Z1s)\u0005A\u0004\"\u00025\u0001\t\u0003J\u0017\u0001\u0003\u0013qYV\u001cH%Z9\u0015\u0005)\\W\"\u0001\u0001\t\u000b1<\u0007\u0019\u0001\u000b\u0002\u0003YDQA\u001c\u0001\u0005\u0002=\faA]3tk2$H#\u0001\u000e\t\u000b9\u0004A\u0011A9\u0015\u0005i\u0011\b\"\u0002'q\u0001\u0004\u0011\u0005\"\u0002;\u0001\t\u0003*\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003Y\u0004\"a\u001e>\u000f\u0005UA\u0018BA=\u0017\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e4\u0002\"\u0002@\u0001\t\u0003y\u0018AB1qa\u0016tG\rF\u0002k\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!A\u0002tKF\u0004B!EA\u0004)%\u0019\u0011\u0011\u0002\u0002\u0003\t1\u001bV-\u001d\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003\u00159(/\u001b;f)\ra\u0013\u0011\u0003\u0005\t\u0003'\tY\u00011\u0001\u0002\u0016\u0005\u00191O]2\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\r\u0003\rq\u0017n\\\u0005\u0005\u0003?\tIB\u0001\u0006CsR,')\u001e4gKJDq!a\t\u0001\t\u0003\t)#\u0001\u0004jg>\u0003XM\u001c\u000b\u0002)!1\u0011\u0011\u0006\u0001\u0005\u0002\u0019\fQa\u00197pg\u0016\u0004")
public class LBitArrayBuilder
implements LBuilder<Object, LBitArray>,
Logger {
    private LLongArray elems;
    private long capacity;
    private long numBits;

    public void log(LogLevel logLevel, Function0<Object> message) {
        Logger.class.log((Logger)this, (LogLevel)logLevel, message);
    }

    public LogWriter getLogger(Symbol tag) {
        return Logger.class.getLogger((Logger)this, (Symbol)tag);
    }

    public LogWriter getLogger(String tag) {
        return Logger.class.getLogger((Logger)this, (String)tag);
    }

    public <U> void log(String tag, Function1<LogWriter, U> f) {
        Logger.class.log((Logger)this, (String)tag, f);
    }

    public void fatal(Function0<Object> message) {
        Logger.class.fatal((Logger)this, message);
    }

    public void error(Function0<Object> message) {
        Logger.class.error((Logger)this, message);
    }

    public void warn(Function0<Object> message) {
        Logger.class.warn((Logger)this, message);
    }

    public void info(Function0<Object> message) {
        Logger.class.info((Logger)this, message);
    }

    public void debug(Function0<Object> message) {
        Logger.class.debug((Logger)this, message);
    }

    public void trace(Function0<Object> message) {
        Logger.class.trace((Logger)this, message);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public LBuilder append(Object elem) {
        return LBuilder$class.append(this, elem);
    }

    @Override
    public LBuilder<Object, LBitArray> $plus$plus$eq(TraversableOnce<Object> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    @Override
    public LBuilder<Object, LBitArray> $plus$plus$eq(LIterator<Object> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    public Nothing$ elementSize() {
        throw new UnsupportedOperationException("elementSize of LBitArrayBuilder");
    }

    private LLongArray elems() {
        return this.elems;
    }

    private void elems_$eq(LLongArray x$1) {
        this.elems = x$1;
    }

    private long capacity() {
        return this.capacity;
    }

    private void capacity_$eq(long x$1) {
        this.capacity = x$1;
    }

    private long numBits() {
        return this.numBits;
    }

    private void numBits_$eq(long x$1) {
        this.numBits = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LLongArray mkArray(long size2) {
        void var3_2;
        LLongArray newArray = new LLongArray(BitEncoder$.MODULE$.minArraySize(size2), package$.MODULE$.defaultAllocator());
        newArray.clear();
        if (this.capacity() > 0L) {
            LArray$.MODULE$.copy(this.elems(), newArray);
            this.elems().free();
        }
        return var3_2;
    }

    @Override
    public void sizeHint(long size2) {
        if (this.capacity() < size2) {
            this.resize(size2);
        }
    }

    public void ensureSize(long size2) {
        long factor = 2L;
        if (this.capacity() < size2 || this.capacity() == 0L) {
            long newsize;
            long l = newsize = this.capacity() <= 1L ? 64L : this.capacity() * factor;
            while (newsize < size2) {
                newsize *= factor;
            }
            this.resize(newsize);
        }
    }

    public void resize(long size2) {
        this.elems_$eq(this.mkArray(size2));
        this.capacity_$eq(size2);
    }

    @Override
    public void clear() {
        if (this.numBits() > 0L) {
            this.elems().free();
        }
        this.capacity_$eq(0L);
        this.numBits_$eq(0L);
    }

    public LBitArrayBuilder $plus$eq(boolean v) {
        long l;
        this.ensureSize(this.numBits() + 1L);
        long pos = BitEncoder$.MODULE$.blockIndex(this.numBits());
        int offset = BitEncoder$.MODULE$.blockOffset(this.numBits());
        if (v) {
            LLongArray lLongArray = this.elems();
            l = lLongArray.update(pos, lLongArray.apply(pos) | 1L << offset);
        } else {
            LLongArray lLongArray = this.elems();
            l = lLongArray.update(pos, lLongArray.apply(pos) & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.numBits_$eq(this.numBits() + 1L);
        return this;
    }

    @Override
    public LBitArray result() {
        long s = BitEncoder$.MODULE$.minArraySize(this.numBits());
        return this.capacity() != 0L && this.capacity() == s ? new LBitArray(this.elems(), this.numBits()) : new LBitArray(this.mkArray(this.numBits()), this.numBits());
    }

    public LBitArray result(long numBits) {
        this.numBits_$eq(numBits);
        return this.result();
    }

    public String toString() {
        return this.result().toString();
    }

    public LBitArrayBuilder append(LSeq<Object> seq) {
        long N = seq.length();
        this.ensureSize(this.numBits() + N);
        for (long i = 0L; i < N; ++i) {
            this.$plus$eq(BoxesRunTime.unboxToBoolean((Object)seq.apply(i)));
        }
        this.numBits_$eq(this.numBits() + N);
        return this;
    }

    public Nothing$ write(ByteBuffer src) {
        throw new UnsupportedOperationException("write(ByteBuffer)");
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    public LBitArrayBuilder() {
        LBuilder$class.$init$(this);
        Logger.class.$init$((Logger)this);
        this.capacity = 0L;
        this.numBits = 0L;
    }
}

