/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.drift.TApplicationException;
import com.facebook.drift.TException;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.ParameterMetadata;
import com.facebook.drift.transport.client.DriftApplicationException;
import com.facebook.drift.transport.client.MessageTooLargeException;
import com.facebook.drift.transport.client.RequestTimeoutException;
import com.facebook.drift.transport.netty.client.ExceptionReader;
import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.FrameTooLargeException;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.ThriftFrame;
import com.facebook.drift.transport.netty.codec.ThriftHeaderTransform;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferInputTransport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferOutputTransport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.units.Duration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThriftClientHandler
extends ChannelDuplexHandler {
    private static final int ONEWAY_SEQUENCE_ID = -1;
    private final Duration requestTimeout;
    private final Transport transport;
    private final Protocol protocol;
    private final ConcurrentHashMap<Integer, RequestHandler> pendingRequests = new ConcurrentHashMap();
    private final AtomicReference<TException> channelError = new AtomicReference();
    private final AtomicInteger sequenceId = new AtomicInteger(42);

    ThriftClientHandler(Duration requestTimeout, Transport transport, Protocol protocol) {
        this.requestTimeout = Objects.requireNonNull(requestTimeout, "requestTimeout is null");
        this.transport = Objects.requireNonNull(transport, "transport is null");
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
    }

    public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
        if (message instanceof ThriftRequest) {
            ThriftRequest thriftRequest = (ThriftRequest)((Object)message);
            this.sendMessage(ctx, thriftRequest, promise);
        } else {
            ctx.write(message, promise);
        }
    }

    private void sendMessage(ChannelHandlerContext context, ThriftRequest thriftRequest, ChannelPromise promise) throws Exception {
        int sequenceId = thriftRequest.isOneway() ? -1 : this.sequenceId.incrementAndGet();
        RequestHandler requestHandler = new RequestHandler(thriftRequest, sequenceId);
        requestHandler.registerRequestTimeout(context.executor());
        ByteBuf requestBuffer = requestHandler.encodeRequest(context.alloc());
        if (!thriftRequest.isOneway() && this.pendingRequests.putIfAbsent(sequenceId, requestHandler) != null) {
            requestHandler.onChannelError((Throwable)new TTransportException("Another request with the same sequenceId is already in progress"));
            requestBuffer.release();
            return;
        }
        TException channelError = this.channelError.get();
        if (channelError != null) {
            thriftRequest.failed(channelError);
            requestBuffer.release();
            return;
        }
        try {
            ThriftFrame thriftFrame = new ThriftFrame(sequenceId, requestBuffer, thriftRequest.getHeaders(), (List<ThriftHeaderTransform>)ImmutableList.of(), this.transport, this.protocol, true);
            ChannelFuture sendFuture = context.write((Object)thriftFrame, promise);
            sendFuture.addListener(future -> this.messageSent(context, sendFuture, requestHandler));
        }
        catch (Throwable t) {
            this.onError(context, t, Optional.of(requestHandler));
            requestBuffer.release();
        }
    }

    private void messageSent(ChannelHandlerContext context, ChannelFuture future, RequestHandler requestHandler) {
        try {
            if (!future.isSuccess()) {
                this.onError(context, (Throwable)new TTransportException("Sending request failed", future.cause()), Optional.of(requestHandler));
                return;
            }
            requestHandler.onRequestSent();
        }
        catch (Throwable t) {
            this.onError(context, t, Optional.of(requestHandler));
        }
    }

    public void channelRead(ChannelHandlerContext context, Object message) {
        if (message instanceof ThriftFrame) {
            this.messageReceived(context, (ThriftFrame)message);
            return;
        }
        context.fireChannelRead(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(ChannelHandlerContext context, ThriftFrame thriftFrame) {
        RequestHandler requestHandler = null;
        try {
            requestHandler = this.pendingRequests.remove(thriftFrame.getSequenceId());
            if (requestHandler == null) {
                throw new TTransportException("Unknown sequence id in response: " + thriftFrame.getSequenceId());
            }
            requestHandler.onResponseReceived(thriftFrame.retain());
        }
        catch (Throwable t) {
            this.onError(context, t, Optional.ofNullable(requestHandler));
        }
        finally {
            thriftFrame.release();
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.onError(context, cause, Optional.empty());
    }

    public void channelInactive(ChannelHandlerContext context) {
        this.onError(context, (Throwable)new TTransportException("Client was disconnected by server"), Optional.empty());
    }

    private void onError(ChannelHandlerContext context, Throwable throwable, Optional<RequestHandler> currentRequest) {
        if (throwable instanceof FrameTooLargeException) {
            Preconditions.checkArgument((!currentRequest.isPresent() ? 1 : 0) != 0, (Object)"current request should not be set for FrameTooLargeException");
            this.onFrameTooLargeException(context, (FrameTooLargeException)((Object)throwable));
            return;
        }
        TException thriftException = throwable instanceof TException ? (TException)throwable : new TTransportException(throwable);
        if (!this.channelError.compareAndSet(null, thriftException)) {
            return;
        }
        currentRequest.ifPresent(request -> {
            this.pendingRequests.remove(request.getSequenceId());
            request.onChannelError(thriftException);
        });
        while (!this.pendingRequests.isEmpty()) {
            this.pendingRequests.values().removeIf(request -> {
                request.onChannelError(thriftException);
                return true;
            });
        }
        context.close();
    }

    private void onFrameTooLargeException(ChannelHandlerContext context, FrameTooLargeException frameTooLargeException) {
        RequestHandler request;
        MessageTooLargeException thriftException = new MessageTooLargeException(frameTooLargeException.getMessage(), (Throwable)((Object)frameTooLargeException));
        Optional<FrameInfo> frameInfo = frameTooLargeException.getFrameInfo();
        if (frameInfo.isPresent() && (request = this.pendingRequests.remove(frameInfo.get().getSequenceId())) != null) {
            request.onChannelError((Throwable)thriftException);
            return;
        }
        this.onError(context, (Throwable)new MessageTooLargeException("unexpected too large response happened on communication channel", (Throwable)((Object)frameTooLargeException)), Optional.empty());
    }

    private final class RequestHandler {
        private final ThriftRequest thriftRequest;
        private final int sequenceId;
        private final AtomicBoolean finished = new AtomicBoolean();
        private final AtomicReference<ScheduledFuture<?>> timeout = new AtomicReference();

        public RequestHandler(ThriftRequest thriftRequest, int sequenceId) {
            this.thriftRequest = thriftRequest;
            this.sequenceId = sequenceId;
        }

        public int getSequenceId() {
            return this.sequenceId;
        }

        void registerRequestTimeout(EventExecutor executor) {
            try {
                this.timeout.set(executor.schedule(() -> this.onChannelError((Throwable)new RequestTimeoutException("Timed out waiting " + ThriftClientHandler.this.requestTimeout + " to receive response")), ThriftClientHandler.this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS));
            }
            catch (Throwable throwable) {
                this.onChannelError((Throwable)new TTransportException("Unable to schedule request timeout", throwable));
                throw throwable;
            }
        }

        ByteBuf encodeRequest(ByteBufAllocator allocator) throws Exception {
            TChannelBufferOutputTransport transport = new TChannelBufferOutputTransport(allocator);
            try {
                TProtocol protocolWriter = ThriftClientHandler.this.protocol.createProtocol(transport);
                MethodMetadata method = this.thriftRequest.getMethod();
                protocolWriter.writeMessageBegin(new TMessage(method.getName(), method.isOneway() ? (byte)4 : 1, this.sequenceId));
                ProtocolWriter writer = new ProtocolWriter((TProtocolWriter)protocolWriter);
                writer.writeStructBegin(method.getName() + "_args");
                List<Object> parameters = this.thriftRequest.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    Object value = parameters.get(i);
                    ParameterMetadata parameter = (ParameterMetadata)method.getParameters().get(i);
                    writer.writeField(parameter.getName(), parameter.getFieldId(), parameter.getCodec(), value);
                }
                writer.writeStructEnd();
                protocolWriter.writeMessageEnd();
                ByteBuf byteBuf = transport.getBuffer();
                return byteBuf;
            }
            catch (Throwable throwable) {
                this.onChannelError(throwable);
                throw throwable;
            }
            finally {
                transport.release();
            }
        }

        void onRequestSent() {
            if (!this.thriftRequest.isOneway()) {
                return;
            }
            if (!this.finished.compareAndSet(false, true)) {
                return;
            }
            try {
                this.cancelRequestTimeout();
                this.thriftRequest.setResponse(null);
            }
            catch (Throwable throwable) {
                this.onChannelError(throwable);
            }
        }

        void onResponseReceived(ThriftFrame thriftFrame) {
            try {
                if (!this.finished.compareAndSet(false, true)) {
                    return;
                }
                this.cancelRequestTimeout();
                Object response = this.decodeResponse(thriftFrame.getMessage());
                this.thriftRequest.setResponse(response);
            }
            catch (Throwable throwable) {
                this.thriftRequest.failed(throwable);
            }
            finally {
                thriftFrame.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object decodeResponse(ByteBuf responseMessage) throws Exception {
            TChannelBufferInputTransport transport = new TChannelBufferInputTransport(responseMessage);
            try {
                Object object;
                TProtocol protocolReader = ThriftClientHandler.this.protocol.createProtocol(transport);
                MethodMetadata method = this.thriftRequest.getMethod();
                TMessage message = protocolReader.readMessageBegin();
                if (message.getType() == 3) {
                    TApplicationException exception = ExceptionReader.readTApplicationException((TProtocolReader)protocolReader);
                    protocolReader.readMessageEnd();
                    throw exception;
                }
                if (message.getType() != 2) {
                    throw new TApplicationException(TApplicationException.Type.INVALID_MESSAGE_TYPE, String.format("Received invalid message type %s from server", message.getType()));
                }
                if (!message.getName().equals(method.getName())) {
                    throw new TApplicationException(TApplicationException.Type.WRONG_METHOD_NAME, String.format("Wrong method name in reply: expected %s but received %s", method.getName(), message.getName()));
                }
                if (message.getSequenceId() != this.sequenceId) {
                    throw new TApplicationException(TApplicationException.Type.BAD_SEQUENCE_ID, String.format("%s failed: out of sequence response", method.getName()));
                }
                ProtocolReader reader = new ProtocolReader((TProtocolReader)protocolReader);
                reader.readStructBegin();
                Object results = null;
                Exception exception = null;
                while (reader.nextField()) {
                    if (reader.getFieldId() == 0) {
                        results = reader.readField(method.getResultCodec());
                        continue;
                    }
                    ThriftCodec exceptionCodec = (ThriftCodec)method.getExceptionCodecs().get(reader.getFieldId());
                    if (exceptionCodec != null) {
                        exception = (Exception)reader.readField(exceptionCodec);
                        continue;
                    }
                    reader.skipFieldData();
                }
                reader.readStructEnd();
                protocolReader.readMessageEnd();
                if (exception != null) {
                    throw new DriftApplicationException(exception);
                }
                if (method.getResultCodec().getType() == ThriftType.VOID) {
                    object = null;
                    return object;
                }
                if (results == null) {
                    throw new TApplicationException(TApplicationException.Type.MISSING_RESULT, String.format("%s failed: unknown result", method.getName()));
                }
                object = results;
                return object;
            }
            finally {
                transport.release();
            }
        }

        void onChannelError(Throwable requestException) {
            if (!this.finished.compareAndSet(false, true)) {
                return;
            }
            try {
                this.cancelRequestTimeout();
            }
            finally {
                this.thriftRequest.failed(requestException);
            }
        }

        private void cancelRequestTimeout() {
            ScheduledFuture<?> timeout = this.timeout.get();
            if (timeout != null) {
                timeout.cancel(false);
            }
        }
    }

    public static class ThriftRequest
    extends AbstractFuture<Object> {
        private final MethodMetadata method;
        private final List<Object> parameters;
        private final Map<String, String> headers;

        public ThriftRequest(MethodMetadata method, List<Object> parameters, Map<String, String> headers) {
            this.method = method;
            this.parameters = parameters;
            this.headers = headers;
        }

        MethodMetadata getMethod() {
            return this.method;
        }

        List<Object> getParameters() {
            return this.parameters;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        boolean isOneway() {
            return this.method.isOneway();
        }

        void setResponse(Object response) {
            this.set(response);
        }

        void failed(Throwable throwable) {
            this.setException(throwable);
        }
    }
}

