/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.OrcProto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;

public abstract class InStream
extends InputStream {
    private final boolean useVInts;

    protected InStream(boolean useVInts) {
        this.useVInts = useVInts;
    }

    public abstract int loadIndeces(List<OrcProto.RowIndexEntry> var1, int var2);

    public abstract void seek(int var1) throws IOException;

    public static InStream create(String name, FSDataInputStream file, long streamOffset, int streamLength, CompressionCodec codec, int bufferSize) throws IOException {
        return InStream.create(name, file, streamOffset, streamLength, codec, bufferSize, true, 1);
    }

    public static InStream create(String name, FSDataInputStream file, long streamOffset, int streamLength, CompressionCodec codec, int bufferSize, boolean useVInts, int readStrides) throws IOException {
        if (codec == null) {
            return new UncompressedStream(name, file, streamOffset, streamLength, useVInts);
        }
        return new CompressedStream(name, file, streamOffset, streamLength, codec, bufferSize, useVInts, readStrides);
    }

    public static InStream create(String name, ByteBuffer input, CompressionCodec codec, int bufferSize) throws IOException {
        return InStream.create(name, input, codec, bufferSize, true);
    }

    public static InStream create(String name, ByteBuffer input, CompressionCodec codec, int bufferSize, boolean useVInts) throws IOException {
        if (codec == null) {
            return new UncompressedStream(name, input, useVInts);
        }
        return new CompressedStream(name, input, codec, bufferSize, useVInts);
    }

    public boolean useVInts() {
        return this.useVInts;
    }

    public static void read(FSDataInputStream file, long fileOffset, byte[] array, int arrayOffset, int length) throws IOException {
        file.seek(fileOffset);
        file.readFully(array, arrayOffset, length);
    }

    private static class CompressedStream
    extends InStream {
        private final String name;
        private byte[] array;
        private final int bufferSize;
        private ByteBuffer uncompressed = null;
        private final CompressionCodec codec;
        private final FSDataInputStream file;
        private final long base;
        private final int limit;
        private boolean isUncompressedOriginal;
        private int[] compressedIndeces;
        private int[] compressedStrides;
        private int[] uncompressedIndeces;
        private long[] chunkStarts;
        private int chunkLength;
        private int compressedOffset;
        private int previousOffset = -1;
        private int currentChunk;
        private int numChunks;
        private final int readStrides;

        public CompressedStream(String name, FSDataInputStream file, long streamOffset, int streamLength, CompressionCodec codec, int bufferSize, boolean useVInts, int readStrides) {
            super(useVInts);
            this.array = null;
            this.name = name;
            this.codec = codec;
            this.bufferSize = bufferSize;
            this.readStrides = readStrides;
            this.file = file;
            this.base = streamOffset;
            this.limit = streamLength;
            this.currentChunk = 0;
            this.compressedOffset = this.limit;
            this.chunkLength = this.limit;
            this.numChunks = this.limit == 0 ? 0 : 1;
        }

        public CompressedStream(String name, ByteBuffer input, CompressionCodec codec, int bufferSize, boolean useVInts) {
            super(useVInts);
            this.array = input.array();
            this.name = name;
            this.codec = codec;
            this.bufferSize = bufferSize;
            this.base = input.arrayOffset() + input.position();
            this.compressedOffset = (int)this.base;
            this.limit = input.arrayOffset() + input.limit();
            this.file = null;
            this.readStrides = -1;
            this.currentChunk = 1;
            this.numChunks = 1;
            this.chunkLength = this.limit;
        }

        @Override
        public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
            int numIndeces = rowIndexEntries.size();
            this.compressedStrides = new int[numIndeces];
            this.compressedIndeces = new int[numIndeces];
            this.uncompressedIndeces = new int[numIndeces];
            this.chunkStarts = new long[numIndeces + 1];
            int maxLength = 0;
            int length = 0;
            int i = 0;
            this.numChunks = 1;
            this.chunkStarts[0] = this.base;
            int distinctStrides = 0;
            int previousStrideStart = 0;
            for (i = 0; i < rowIndexEntries.size(); ++i) {
                OrcProto.RowIndexEntry rowIndexEntry = rowIndexEntries.get(i);
                int compressedIndex = (int)rowIndexEntry.getPositions(startIndex);
                if (compressedIndex != previousStrideStart) {
                    previousStrideStart = compressedIndex;
                    if (++distinctStrides == this.readStrides) {
                        this.chunkStarts[this.numChunks] = this.base + (long)compressedIndex;
                        length = (int)(this.chunkStarts[this.numChunks] - this.chunkStarts[this.numChunks - 1]);
                        maxLength = maxLength < length ? length : maxLength;
                        ++this.numChunks;
                        distinctStrides = 0;
                    }
                }
                this.compressedStrides[i] = this.numChunks - 1;
                this.compressedIndeces[i] = compressedIndex;
                this.uncompressedIndeces[i] = (int)rowIndexEntry.getPositions(startIndex + 1);
            }
            this.chunkStarts[this.numChunks] = this.base + (long)this.limit;
            length = (int)(this.chunkStarts[this.numChunks] - this.chunkStarts[this.numChunks - 1]);
            int n = maxLength = maxLength < length ? length : maxLength;
            if (this.array == null) {
                this.array = new byte[maxLength];
            }
            return startIndex + 2;
        }

        private void readData() throws IOException {
            if (this.file == null) {
                return;
            }
            long fileOffset = this.base;
            this.chunkLength = this.limit;
            if (this.chunkStarts != null) {
                fileOffset = this.chunkStarts[this.currentChunk];
                this.chunkLength = (int)(this.chunkStarts[this.currentChunk + 1] - this.chunkStarts[this.currentChunk]);
            } else if (this.array == null) {
                this.array = new byte[this.chunkLength];
            }
            InStream.read(this.file, fileOffset, this.array, 0, this.chunkLength);
            ++this.currentChunk;
            this.compressedOffset = 0;
        }

        private void readHeader() throws IOException {
            if (this.compressedOffset >= this.chunkLength) {
                this.readData();
            }
            if (this.chunkLength - this.compressedOffset <= 3) {
                throw new IllegalStateException("Can't read header");
            }
            this.previousOffset = this.compressedOffset;
            int chunkLength = (0xFF & this.array[this.compressedOffset + 2]) << 15 | (0xFF & this.array[this.compressedOffset + 1]) << 7 | (0xFF & this.array[this.compressedOffset]) >> 1;
            if (chunkLength > this.bufferSize) {
                throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
            }
            boolean isOriginal = (this.array[this.compressedOffset] & 1) == 1;
            this.compressedOffset += 3;
            if (isOriginal) {
                this.isUncompressedOriginal = true;
                this.uncompressed = ByteBuffer.wrap(this.array, this.compressedOffset, chunkLength);
            } else {
                if (this.isUncompressedOriginal) {
                    this.uncompressed = ByteBuffer.allocate(this.bufferSize);
                    this.isUncompressedOriginal = false;
                } else if (this.uncompressed == null) {
                    this.uncompressed = ByteBuffer.allocate(this.bufferSize);
                } else {
                    this.uncompressed.clear();
                }
                this.codec.decompress(ByteBuffer.wrap(this.array, this.compressedOffset, chunkLength), this.uncompressed);
            }
            this.compressedOffset += chunkLength;
        }

        @Override
        public int read() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentChunk >= this.numChunks && this.compressedOffset >= this.chunkLength) {
                    return -1;
                }
                this.readHeader();
            }
            return 0xFF & this.uncompressed.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentChunk >= this.numChunks && this.compressedOffset >= this.chunkLength) {
                    return -1;
                }
                this.readHeader();
            }
            int actualLength = Math.min(length, this.uncompressed.remaining());
            System.arraycopy(this.uncompressed.array(), this.uncompressed.arrayOffset() + this.uncompressed.position(), data, offset, actualLength);
            this.uncompressed.position(this.uncompressed.position() + actualLength);
            return actualLength;
        }

        @Override
        public int available() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentChunk >= this.numChunks && this.compressedOffset >= this.chunkLength) {
                    return 0;
                }
                this.readHeader();
            }
            return this.uncompressed.remaining();
        }

        @Override
        public void close() {
            this.array = null;
            this.uncompressed = null;
            this.compressedOffset = this.chunkLength;
            this.currentChunk = this.numChunks;
        }

        @Override
        public void seek(int index) throws IOException {
            int newCompressedOffset;
            int uncompBytes = this.uncompressedIndeces[index];
            int n = newCompressedOffset = this.file == null ? (int)this.base + this.compressedIndeces[index] : (int)((long)this.compressedIndeces[index] - (this.chunkStarts[this.compressedStrides[index]] - this.base));
            if (uncompBytes != 0 || this.uncompressed != null) {
                boolean dataRead = false;
                if (this.currentChunk - 1 != this.compressedStrides[index]) {
                    this.currentChunk = this.compressedStrides[index];
                    this.readData();
                    dataRead = true;
                }
                if (dataRead || this.previousOffset != newCompressedOffset) {
                    this.compressedOffset = newCompressedOffset;
                    this.readHeader();
                }
                this.uncompressed.position((this.isUncompressedOriginal ? newCompressedOffset + 3 : 0) + uncompBytes);
            } else {
                this.currentChunk = this.compressedStrides[index];
                this.readData();
                this.compressedOffset = newCompressedOffset;
            }
        }

        public String toString() {
            return "compressed stream " + this.name + " base: " + this.base + " limit: " + this.limit + " current stride: " + this.currentChunk + " compressed offset: " + this.compressedOffset + (this.uncompressed == null ? "" : " uncompressed: " + this.uncompressed.position() + " to " + this.uncompressed.limit());
        }
    }

    private static class UncompressedStream
    extends InStream {
        private final String name;
        private final FSDataInputStream file;
        private byte[] array;
        private int offset;
        private final long base;
        private final int limit;
        private int[] indeces;

        public UncompressedStream(String name, FSDataInputStream file, long streamOffset, int streamLength, boolean useVInts) {
            super(useVInts);
            this.name = name;
            this.array = null;
            this.file = file;
            this.base = streamOffset;
            this.limit = streamLength;
            this.offset = 0;
        }

        public UncompressedStream(String name, ByteBuffer input, boolean useVInts) {
            super(useVInts);
            this.name = name;
            this.array = input.array();
            this.base = input.arrayOffset() + input.position();
            this.offset = (int)this.base;
            this.limit = input.arrayOffset() + input.limit();
            this.file = null;
        }

        @Override
        public int read() throws IOException {
            if (this.offset == this.limit) {
                return -1;
            }
            if (this.array == null) {
                this.array = new byte[this.limit];
                this.file.read(this.base, this.array, 0, this.limit);
            }
            return 0xFF & this.array[this.offset++];
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (this.offset == this.limit) {
                return -1;
            }
            if (this.array == null) {
                this.array = new byte[this.limit];
                this.file.read(this.base, this.array, 0, this.limit);
            }
            int actualLength = Math.min(length, this.limit - this.offset);
            System.arraycopy(this.array, this.offset, data, offset, actualLength);
            this.offset += actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            return this.limit - this.offset;
        }

        @Override
        public void close() {
            this.array = null;
            this.offset = 0;
        }

        @Override
        public void seek(int index) throws IOException {
            this.offset = (int)this.base + this.indeces[index];
        }

        public String toString() {
            return "uncompressed stream " + this.name + " base: " + this.base + " offset: " + this.offset + " limit: " + this.limit;
        }

        @Override
        public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
            this.indeces = new int[rowIndexEntries.size()];
            int i = 0;
            for (OrcProto.RowIndexEntry rowIndexEntry : rowIndexEntries) {
                this.indeces[i] = (int)rowIndexEntry.getPositions(startIndex);
                ++i;
            }
            return startIndex + 1;
        }
    }
}

