/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.lazy.LazyNumericDirectTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;

class LazyIntDirectTreeReader
extends LazyNumericDirectTreeReader {
    private int latestRead;

    LazyIntDirectTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    private int readInt() throws IOException {
        this.latestRead = (int)SerializationUtils.readIntegerType(this.input, 4, true, this.input.useVInts());
        return this.latestRead;
    }

    IntWritable createWritable(Object previous, int v) throws IOException {
        IntWritable result = null;
        result = previous == null ? new IntWritable() : (IntWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestRead);
    }

    @Override
    public int nextInt(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestRead;
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize int.");
        }
        return this.readInt();
    }

    @Override
    public Object next(Object previous) throws IOException {
        IntWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readInt());
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        int i = 0;
        while ((long)i < numNonNullValues) {
            SerializationUtils.readIntegerType(this.input, 4, true, this.input.useVInts());
            ++i;
        }
    }
}

