/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.typeconverter.impl;

import com.facebook.presto.hive.$internal.jodd.datetime.JDateTime;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConversionException;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverter;
import com.facebook.presto.hive.$internal.jodd.util.StringUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimestampConverter
implements TypeConverter<Timestamp> {
    @Override
    public Timestamp convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return new Timestamp(calendar.getTimeInMillis());
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof JDateTime) {
            return ((JDateTime)value).convertToSqlTimestamp();
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Timestamp(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

