/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.facebook.presto.hive.$internal.org.apache.commons.lang.ArrayUtils;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class VectorColumnOrderedMap {
    protected static final transient Log LOG = LogFactory.getLog(VectorColumnOrderedMap.class);
    protected String name;
    private TreeMap<Integer, Value> orderedTreeMap;

    public VectorColumnOrderedMap(String name) {
        this.name = name;
        this.orderedTreeMap = new TreeMap();
    }

    public void add(int orderedColumn, int valueColumn, String typeName) {
        if (this.orderedTreeMap.containsKey(orderedColumn)) {
            throw new RuntimeException(this.name + " duplicate column " + orderedColumn + " in ordered column map " + this.orderedTreeMap.toString() + " when adding value column " + valueColumn + ", type " + typeName);
        }
        this.orderedTreeMap.put(orderedColumn, new Value(valueColumn, typeName));
    }

    public boolean orderedColumnsContain(int orderedColumn) {
        return this.orderedTreeMap.containsKey(orderedColumn);
    }

    public Mapping getMapping() {
        ArrayList<Integer> orderedColumns = new ArrayList<Integer>();
        ArrayList<Integer> valueColumns = new ArrayList<Integer>();
        ArrayList<String> typeNames = new ArrayList<String>();
        for (Map.Entry<Integer, Value> entry : this.orderedTreeMap.entrySet()) {
            orderedColumns.add(entry.getKey());
            Value value = entry.getValue();
            valueColumns.add(value.valueColumn);
            typeNames.add(value.typeName);
        }
        return new Mapping(ArrayUtils.toPrimitive(orderedColumns.toArray(new Integer[0])), ArrayUtils.toPrimitive(valueColumns.toArray(new Integer[0])), typeNames.toArray(new String[0]));
    }

    public class Mapping {
        private final int[] orderedColumns;
        private final int[] valueColumns;
        private final String[] typeNames;

        Mapping(int[] orderedColumns, int[] valueColumns, String[] typeNames) {
            this.orderedColumns = orderedColumns;
            this.valueColumns = valueColumns;
            this.typeNames = typeNames;
        }

        public int getCount() {
            return this.orderedColumns.length;
        }

        public int[] getOrderedColumns() {
            return this.orderedColumns;
        }

        public int[] getValueColumns() {
            return this.valueColumns;
        }

        public String[] getTypeNames() {
            return this.typeNames;
        }
    }

    private class Value {
        int valueColumn;
        String typeName;

        Value(int valueColumn, String typeName) {
            this.valueColumn = valueColumn;
            this.typeName = typeName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(value column: " + this.valueColumn);
            sb.append(", type name: " + this.typeName + ")");
            return sb.toString();
        }
    }
}

