/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class ConstantPropagate
implements Transform {
    private static final Log LOG = LogFactory.getLog(ConstantPropagate.class);
    protected ParseContext pGraphContext;
    private ConstantPropagateProcCtx.ConstantPropagateOption constantPropagateOption;

    public ConstantPropagate() {
        this(ConstantPropagateProcCtx.ConstantPropagateOption.FULL);
    }

    public ConstantPropagate(ConstantPropagateProcCtx.ConstantPropagateOption option) {
        this.constantPropagateOption = option;
    }

    @Override
    public ParseContext transform(ParseContext pactx) throws SemanticException {
        this.pGraphContext = pactx;
        ConstantPropagateProcCtx cppCtx = new ConstantPropagateProcCtx(this.constantPropagateOption);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", FilterOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getFilterProc());
        opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getGroupByProc());
        opRules.put(new RuleRegExp("R3", SelectOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getSelectProc());
        opRules.put(new RuleRegExp("R4", FileSinkOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getFileSinkProc());
        opRules.put(new RuleRegExp("R5", ReduceSinkOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getReduceSinkProc());
        opRules.put(new RuleRegExp("R6", JoinOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getJoinProc());
        opRules.put(new RuleRegExp("R7", TableScanOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getTableScanProc());
        opRules.put(new RuleRegExp("R8", ScriptOperator.getOperatorName() + "%"), ConstantPropagateProcFactory.getStopProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ConstantPropagateProcFactory.getDefaultProc(), opRules, cppCtx);
        ConstantPropagateWalker ogw = new ConstantPropagateWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        for (Operator<? extends Serializable> opToDelete : cppCtx.getOpToDelete()) {
            if (opToDelete.getParentOperators() == null || opToDelete.getParentOperators().size() != 1) {
                throw new RuntimeException("Error pruning operator " + opToDelete + ". It should have only 1 parent.");
            }
            opToDelete.getParentOperators().get(0).removeChildAndAdoptItsChildren(opToDelete);
        }
        return this.pGraphContext;
    }

    public static class ConstantPropagateWalker
    extends DefaultGraphWalker {
        public ConstantPropagateWalker(Dispatcher disp) {
            super(disp);
        }

        @Override
        public void walk(Node nd) throws SemanticException {
            List<Operator<OperatorDesc>> parents = ((Operator)nd).getParentOperators();
            if (parents != null && !this.getDispatchedList().containsAll(parents)) {
                this.getToWalk().removeAll(parents);
                this.getToWalk().add(0, nd);
                this.getToWalk().addAll(0, parents);
                return;
            }
            this.opStack.push(nd);
            this.dispatch(nd, this.opStack);
            this.opStack.pop();
            List<? extends Node> children = nd.getChildren();
            if (children != null) {
                this.getToWalk().removeAll(children);
                this.getToWalk().addAll(children);
            }
        }
    }
}

