/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;

public class RemoveDynamicPruningBySize
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog(RemoveDynamicPruningBySize.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procContext;
        AppMasterEventOperator event = (AppMasterEventOperator)nd;
        AppMasterEventDesc desc = (AppMasterEventDesc)event.getConf();
        if (desc.getStatistics().getDataSize() > context.conf.getLongVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING_MAX_DATA_SIZE) && (context.pruningOpsRemovedByPriorOpt.isEmpty() || !context.pruningOpsRemovedByPriorOpt.contains(event))) {
            context.pruningOpsRemovedByPriorOpt.add(event);
            GenTezUtils.getUtils().removeBranch(event);
            LOG.info("Disabling dynamic pruning for: " + ((DynamicPruningEventDesc)desc).getTableScan().getName() + ". Expected data size is too big: " + desc.getStatistics().getDataSize());
        }
        return false;
    }
}

