/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.thrift.TException;

public class StatsOptimizer
implements Transform {
    private static final Log Log = LogFactory.getLog(StatsOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (pctx.getFetchTask() != null || !pctx.getQueryProperties().isQuery() || pctx.getQueryProperties().isAnalyzeRewrite() || pctx.getQueryProperties().isCTAS() || pctx.getLoadFileWork().size() > 1 || !pctx.getLoadTableWork().isEmpty()) {
            return pctx;
        }
        String TS = TableScanOperator.getOperatorName() + "%";
        String GBY = GroupByOperator.getOperatorName() + "%";
        String RS = ReduceSinkOperator.getOperatorName() + "%";
        String SEL = SelectOperator.getOperatorName() + "%";
        String FS = FileSinkOperator.getOperatorName() + "%";
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TS + SEL + GBY + RS + GBY + SEL + FS), new MetaDataProcessor(pctx));
        opRules.put(new RuleRegExp("R2", TS + SEL + GBY + RS + GBY + FS), new MetaDataProcessor(pctx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class MetaDataProcessor
    implements NodeProcessor {
        private final ParseContext pctx;

        public MetaDataProcessor(ParseContext pctx) {
            this.pctx = pctx;
        }

        private StatType getType(String origType) {
            if (serdeConstants.IntegralTypes.contains(origType)) {
                return StatType.Integeral;
            }
            if (origType.equals("double") || origType.equals("float")) {
                return StatType.Double;
            }
            if (origType.equals("binary")) {
                return StatType.Binary;
            }
            if (origType.equals("boolean")) {
                return StatType.Boolean;
            }
            if (origType.equals("string")) {
                return StatType.String;
            }
            return StatType.Unsupported;
        }

        private Long getNullcountFor(StatType type, ColumnStatisticsData statData) {
            switch (type) {
                case Integeral: {
                    return statData.getLongStats().getNumNulls();
                }
                case Double: {
                    return statData.getDoubleStats().getNumNulls();
                }
                case String: {
                    return statData.getStringStats().getNumNulls();
                }
                case Boolean: {
                    return statData.getBooleanStats().getNumNulls();
                }
                case Binary: {
                    return statData.getBinaryStats().getNumNulls();
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            try {
                FileSinkOperator fsOp;
                TableScanOperator tsOp = (TableScanOperator)stack.get(0);
                if (tsOp.getNumParent() > 0) {
                    return null;
                }
                SelectOperator pselOp = (SelectOperator)stack.get(1);
                for (ExprNodeDesc desc : ((SelectDesc)pselOp.getConf()).getColList()) {
                    if (desc instanceof ExprNodeColumnDesc || desc instanceof ExprNodeConstantDesc) continue;
                    return null;
                }
                Map<String, ExprNodeDesc> exprMap = pselOp.getColumnExprMap();
                GroupByOperator pgbyOp = (GroupByOperator)stack.get(2);
                if (((GroupByDesc)pgbyOp.getConf()).getOutputColumnNames().size() != ((GroupByDesc)pgbyOp.getConf()).getAggregators().size()) {
                    return null;
                }
                ReduceSinkOperator rsOp = (ReduceSinkOperator)stack.get(3);
                if (((ReduceSinkDesc)rsOp.getConf()).getDistinctColumnIndices().size() > 0) {
                    return null;
                }
                GroupByOperator cgbyOp = (GroupByOperator)stack.get(4);
                if (((GroupByDesc)cgbyOp.getConf()).getOutputColumnNames().size() != ((GroupByDesc)cgbyOp.getConf()).getAggregators().size()) {
                    return null;
                }
                Operator last = (Operator)stack.get(5);
                if (last instanceof SelectOperator) {
                    SelectOperator cselOp = (SelectOperator)last;
                    if (!cselOp.isIdentitySelect()) {
                        return null;
                    }
                    last = (Operator)stack.get(6);
                }
                if ((fsOp = (FileSinkOperator)last).getNumChild() > 0) {
                    return null;
                }
                Table tbl = ((TableScanDesc)tsOp.getConf()).getTableMetadata();
                ArrayList<Object> oneRow = new ArrayList<Object>();
                Hive hive = Hive.get(this.pctx.getConf());
                for (AggregationDesc aggr : ((GroupByDesc)pgbyOp.getConf()).getAggregators()) {
                    DoubleColumnStatsData dstats;
                    long curVal;
                    LongColumnStatsData lstats;
                    ColumnStatisticsData statData;
                    Collection<List<ColumnStatisticsObj>> result;
                    Enum subType;
                    String name;
                    Set<Partition> parts;
                    StatType type;
                    String colName;
                    Object colDesc;
                    if (aggr.getDistinct()) {
                        return null;
                    }
                    GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(aggr.getGenericUDAFName());
                    if (udaf instanceof GenericUDAFSum) {
                        String constant;
                        ExprNodeDesc desc = aggr.getParameters().get(0);
                        PrimitiveObjectInspector.PrimitiveCategory category = GenericUDAFSum.getReturnType(desc.getTypeInfo());
                        if (category == null) {
                            return null;
                        }
                        if (desc instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)desc).getValue().toString();
                        } else if (desc instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)desc).getColumn()) instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)desc).getColumn())).getValue().toString();
                        } else {
                            return null;
                        }
                        Long rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                        if (rowCnt == null) {
                            return null;
                        }
                        switch (category) {
                            case LONG: {
                                oneRow.add(Long.valueOf(constant) * rowCnt);
                                break;
                            }
                            case DOUBLE: {
                                oneRow.add(Double.valueOf(constant) * (double)rowCnt.longValue());
                                break;
                            }
                            case DECIMAL: {
                                oneRow.add(HiveDecimal.create(constant).multiply(HiveDecimal.create(rowCnt)));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("never");
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFCount) {
                        Long rowCnt = 0L;
                        if (aggr.getParameters().isEmpty() || aggr.getParameters().get(0) instanceof ExprNodeConstantDesc || aggr.getParameters().get(0) instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn()) instanceof ExprNodeConstantDesc) {
                            rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                            if (rowCnt == null) {
                                return null;
                            }
                        } else {
                            ExprNodeColumnDesc desc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                            String colName2 = desc.getColumn();
                            StatType type2 = this.getType(desc.getTypeString());
                            if (!tbl.isPartitioned()) {
                                if (!StatsSetupConst.areStatsUptoDate(tbl.getParameters())) {
                                    Log.debug("Stats for table : " + tbl.getTableName() + " are not upto date.");
                                    return null;
                                }
                                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                                if (rowCnt < 1L) {
                                    Log.debug("Table doesn't have upto date stats " + tbl.getTableName());
                                    return null;
                                }
                                List<ColumnStatisticsObj> stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName2));
                                if (stats.isEmpty()) {
                                    Log.debug("No stats for " + tbl.getTableName() + " column " + colName2);
                                    return null;
                                }
                                Long nullCnt = this.getNullcountFor(type2, stats.get(0).getStatsData());
                                if (null == nullCnt) {
                                    Log.debug("Unsupported type: " + desc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName2);
                                    return null;
                                }
                                rowCnt = rowCnt - nullCnt;
                            } else {
                                Set<Partition> parts2 = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                                for (Partition partition : parts2) {
                                    if (!StatsSetupConst.areStatsUptoDate(partition.getParameters())) {
                                        Log.debug("Stats for part : " + partition.getSpec() + " are not upto date.");
                                        return null;
                                    }
                                    Long partRowCnt = Long.parseLong(partition.getParameters().get("numRows"));
                                    if (partRowCnt < 1L) {
                                        Log.debug("Partition doesn't have upto date stats " + partition.getSpec());
                                        return null;
                                    }
                                    rowCnt = rowCnt + partRowCnt;
                                }
                                Collection<List<ColumnStatisticsObj>> result2 = this.verifyAndGetPartStats(hive, tbl, colName2, parts2);
                                if (result2 == null) {
                                    return null;
                                }
                                for (List<ColumnStatisticsObj> statObj : result2) {
                                    ColumnStatisticsData statData2 = this.validateSingleColStat(statObj);
                                    if (statData2 == null) {
                                        return null;
                                    }
                                    Long nullCnt = this.getNullcountFor(type2, statData2);
                                    if (nullCnt == null) {
                                        Log.debug("Unsupported type: " + desc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName2);
                                        return null;
                                    }
                                    rowCnt = rowCnt - nullCnt;
                                }
                            }
                        }
                        oneRow.add(rowCnt);
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMax) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = ((ExprNodeColumnDesc)colDesc).getColumn();
                        type = this.getType(((ExprNodeDesc)colDesc).getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areStatsUptoDate(tbl.getParameters())) {
                                Log.debug("Stats for table : " + tbl.getTableName() + " are not upto date.");
                                return null;
                            }
                            List<ColumnStatisticsObj> stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName));
                            if (stats.isEmpty()) {
                                Log.debug("No stats for " + tbl.getTableName() + " column " + colName);
                                return null;
                            }
                            ColumnStatisticsData statData3 = stats.get(0).getStatsData();
                            String name2 = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                            switch (type) {
                                case Integeral: {
                                    LongSubType longSubType = LongSubType.valueOf(name2);
                                    LongColumnStatsData lstats2 = statData3.getLongStats();
                                    if (lstats2.isSetHighValue()) {
                                        oneRow.add(longSubType.cast(lstats2.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    DoubleSubType doubleSubType = DoubleSubType.valueOf(name2);
                                    DoubleColumnStatsData dstats2 = statData3.getDoubleStats();
                                    if (dstats2.isSetHighValue()) {
                                        oneRow.add(doubleSubType.cast(dstats2.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Log.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                    return null;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                        switch (type) {
                            case Integeral: {
                                void var25_34;
                                subType = LongSubType.valueOf(name);
                                Object var25_33 = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    return null;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        return null;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetHighValue()) continue;
                                    curVal = lstats.getHighValue();
                                    Long l = var25_34 == null ? curVal : Math.max(var25_34.longValue(), curVal);
                                }
                                if (var25_34 != null) {
                                    oneRow.add(((LongSubType)subType).cast(var25_34.longValue()));
                                    break;
                                }
                                oneRow.add(var25_34);
                                break;
                            }
                            case Double: {
                                void var25_37;
                                subType = DoubleSubType.valueOf(name);
                                Object var25_36 = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    return null;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        return null;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetHighValue()) continue;
                                    double curVal2 = statData.getDoubleStats().getHighValue();
                                    Double d = var25_37 == null ? curVal2 : Math.max(var25_37.doubleValue(), curVal2);
                                }
                                if (var25_37 != null) {
                                    oneRow.add(((DoubleSubType)subType).cast(var25_37.doubleValue()));
                                    break;
                                }
                                oneRow.add(null);
                                break;
                            }
                            default: {
                                Log.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                return null;
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMin) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = ((ExprNodeColumnDesc)colDesc).getColumn();
                        type = this.getType(((ExprNodeDesc)colDesc).getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areStatsUptoDate(tbl.getParameters())) {
                                Log.debug("Stats for table : " + tbl.getTableName() + " are not upto date.");
                                return null;
                            }
                            ColumnStatisticsData statData4 = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName)).get(0).getStatsData();
                            name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                            switch (type) {
                                case Integeral: {
                                    subType = LongSubType.valueOf(name);
                                    LongColumnStatsData longColumnStatsData = statData4.getLongStats();
                                    if (longColumnStatsData.isSetLowValue()) {
                                        oneRow.add(((LongSubType)subType).cast(longColumnStatsData.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    subType = DoubleSubType.valueOf(name);
                                    DoubleColumnStatsData doubleColumnStatsData = statData4.getDoubleStats();
                                    if (doubleColumnStatsData.isSetLowValue()) {
                                        oneRow.add(((DoubleSubType)subType).cast(doubleColumnStatsData.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Log.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                    return null;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                        switch (type) {
                            case Integeral: {
                                void var25_44;
                                subType = LongSubType.valueOf(name);
                                Object var25_43 = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    return null;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        return null;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetLowValue()) continue;
                                    curVal = lstats.getLowValue();
                                    Long l = var25_44 == null ? curVal : Math.min(var25_44.longValue(), curVal);
                                }
                                if (var25_44 != null) {
                                    oneRow.add(((LongSubType)subType).cast(var25_44.longValue()));
                                    break;
                                }
                                oneRow.add(var25_44);
                                break;
                            }
                            case Double: {
                                void var25_47;
                                subType = DoubleSubType.valueOf(name);
                                Object var25_46 = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    return null;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        return null;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetLowValue()) continue;
                                    double curVal3 = statData.getDoubleStats().getLowValue();
                                    Double d = var25_47 == null ? curVal3 : Math.min(var25_47.doubleValue(), curVal3);
                                }
                                if (var25_47 != null) {
                                    oneRow.add(((DoubleSubType)subType).cast(var25_47.doubleValue()));
                                    break;
                                }
                                oneRow.add(var25_47);
                                break;
                            }
                            default: {
                                Log.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in " + "metadata optimizer for column : " + colName);
                                return null;
                            }
                        }
                        continue;
                    }
                    Log.debug("Unsupported aggregation for metadata optimizer: " + aggr.getGenericUDAFName());
                    return null;
                }
                ArrayList<List<Object>> allRows = new ArrayList<List<Object>>();
                allRows.add(oneRow);
                ArrayList<String> colNames = new ArrayList<String>();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                for (ColumnInfo colInfo : cgbyOp.getSchema().getSignature()) {
                    colNames.add(colInfo.getInternalName());
                    ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(colInfo.getType()));
                }
                StandardStructObjectInspector sOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, ois);
                FetchWork fWork = new FetchWork(allRows, sOI);
                FetchTask fTask = (FetchTask)TaskFactory.get(fWork, this.pctx.getConf(), new Task[0]);
                fWork.setLimit(allRows.size());
                this.pctx.setFetchTask(fTask);
                return null;
            }
            catch (Exception e) {
                Log.debug("Failed to optimize using metadata optimizer", e);
                return null;
            }
        }

        private ColumnStatisticsData validateSingleColStat(List<ColumnStatisticsObj> statObj) {
            if (statObj.size() > 1) {
                Log.error("More than one stat for a single column!");
                return null;
            }
            if (statObj.isEmpty()) {
                Log.debug("No stats for some partition and column");
                return null;
            }
            return statObj.get(0).getStatsData();
        }

        private Collection<List<ColumnStatisticsObj>> verifyAndGetPartStats(Hive hive, Table tbl, String colName, Set<Partition> parts) throws TException {
            ArrayList<String> partNames = new ArrayList<String>(parts.size());
            for (Partition part : parts) {
                if (!StatsSetupConst.areStatsUptoDate(part.getParameters())) {
                    Log.debug("Stats for part : " + part.getSpec() + " are not upto date.");
                    return null;
                }
                partNames.add(part.getName());
            }
            Map<String, List<ColumnStatisticsObj>> result = hive.getMSC().getPartitionColumnStatistics(tbl.getDbName(), tbl.getTableName(), partNames, Lists.newArrayList(colName));
            if (result.size() != parts.size()) {
                Log.debug("Received " + result.size() + " stats for " + parts.size() + " partitions");
                return null;
            }
            return result.values();
        }

        private Long getRowCnt(ParseContext pCtx, TableScanOperator tsOp, Table tbl) throws HiveException {
            Long rowCnt = 0L;
            if (tbl.isPartitioned()) {
                for (Partition part : this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions()) {
                    long partRowCnt = Long.parseLong(part.getParameters().get("numRows"));
                    if (partRowCnt < 1L) {
                        Log.debug("Partition doesn't have upto date stats " + part.getSpec());
                        return null;
                    }
                    rowCnt = rowCnt + partRowCnt;
                }
            } else {
                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                if (rowCnt < 1L) {
                    Log.debug("Table doesn't have upto date stats " + tbl.getTableName());
                    rowCnt = null;
                }
            }
            return rowCnt;
        }

        static enum DoubleSubType {
            DOUBLE{

                @Override
                Object cast(double doubleValue) {
                    return doubleValue;
                }
            }
            ,
            FLOAT{

                @Override
                Object cast(double doubleValue) {
                    return Float.valueOf((float)doubleValue);
                }
            };


            abstract Object cast(double var1);
        }

        static enum LongSubType {
            BIGINT{

                @Override
                Object cast(long longValue) {
                    return longValue;
                }
            }
            ,
            INT{

                @Override
                Object cast(long longValue) {
                    return (int)longValue;
                }
            }
            ,
            SMALLINT{

                @Override
                Object cast(long longValue) {
                    return (short)longValue;
                }
            }
            ,
            TINYINT{

                @Override
                Object cast(long longValue) {
                    return (byte)longValue;
                }
            };


            abstract Object cast(long var1);
        }

        static enum StatType {
            Integeral,
            Double,
            String,
            Boolean,
            Binary,
            Unsupported;

        }
    }
}

