/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;

public class SpecialCases {
    private static final Log LOG = LogFactory.getLog(SpecialCases.class);

    public static void addSpecialCasesParametersToOutputJobProperties(Map<String, String> jobProperties, OutputJobInfo jobInfo, Class<? extends OutputFormat> ofclass) {
        block5: {
            block6: {
                block4: {
                    if (ofclass != RCFileOutputFormat.class) break block4;
                    jobProperties.put(HiveConf.ConfVars.HIVE_RCFILE_COLUMN_NUMBER_CONF.varname, Integer.toOctalString(jobInfo.getOutputSchema().getFields().size()));
                    break block5;
                }
                if (ofclass != OrcOutputFormat.class) break block6;
                Map<String, String> tableProps = jobInfo.getTableInfo().getTable().getParameters();
                for (OrcFile.OrcTableProperties property : OrcFile.OrcTableProperties.values()) {
                    String propName = property.getPropName();
                    if (!tableProps.containsKey(propName)) continue;
                    jobProperties.put(propName, tableProps.get(propName));
                }
                break block5;
            }
            if (ofclass != AvroContainerOutputFormat.class) break block5;
            Map<String, String> tableProps = jobInfo.getTableInfo().getTable().getParameters();
            for (AvroSerdeUtils.AvroTableProperties property : AvroSerdeUtils.AvroTableProperties.values()) {
                String propName = property.getPropName();
                if (!tableProps.containsKey(propName)) continue;
                String propVal = tableProps.get(propName);
                jobProperties.put(propName, tableProps.get(propName));
            }
            Properties properties = new Properties();
            properties.put("name", jobInfo.getTableName());
            List<String> colNames = jobInfo.getOutputSchema().getFieldNames();
            ArrayList<TypeInfo> colTypes = new ArrayList<TypeInfo>();
            for (HCatFieldSchema field : jobInfo.getOutputSchema().getFields()) {
                colTypes.add(TypeInfoUtils.getTypeInfoFromTypeString(field.getTypeString()));
            }
            jobProperties.put(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), AvroSerDe.getSchemaFromCols(properties, colNames, colTypes, null).toString());
            for (String propName : jobProperties.keySet()) {
                String string = jobProperties.get(propName);
            }
        }
    }

    public static void addSpecialCasesParametersForHCatLoader(Configuration conf, HCatTableInfo tableInfo) {
        if (tableInfo == null || tableInfo.getStorerInfo() == null) {
            return;
        }
        String shClass = tableInfo.getStorerInfo().getStorageHandlerClass();
        if (shClass != null && shClass.equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler")) {
            conf.set("pig.noSplitCombination", "true");
        }
    }
}

