/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.LocalFileColumnHandle;
import com.facebook.presto.localfile.LocalFileSplit;
import com.facebook.presto.localfile.LocalFileTableHandle;
import com.facebook.presto.localfile.LocalFileTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class LocalFileSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public LocalFileSplitManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        LocalFileTableLayoutHandle layoutHandle = (LocalFileTableLayoutHandle)layout;
        LocalFileTableHandle tableHandle = layoutHandle.getTable();
        TupleDomain effectivePredicate = layoutHandle.getConstraint().transform(LocalFileColumnHandle.class::cast);
        List splits = this.nodeManager.getAllNodes().stream().map(node -> new LocalFileSplit(node.getHostAndPort(), tableHandle.getSchemaTableName(), (TupleDomain<LocalFileColumnHandle>)effectivePredicate)).collect(Collectors.toList());
        return new FixedSplitSource(splits);
    }
}

