/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Objects;

public final class ElasticsearchColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type columnType;
    private final String columnJsonPath;
    private final String columnJsonType;
    private final int ordinalPosition;
    private final boolean isList;

    @JsonCreator
    public ElasticsearchColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="columnJsonPath") String columnJsonPath, @JsonProperty(value="columnJsonType") String columnJsonType, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="isList") boolean isList) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.columnJsonPath = Objects.requireNonNull(columnJsonPath, "columnJsonPath is null");
        this.columnJsonType = Objects.requireNonNull(columnJsonType, "columnJsonType is null");
        this.ordinalPosition = ordinalPosition;
        this.isList = isList;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public String getColumnJsonPath() {
        return this.columnJsonPath;
    }

    @JsonProperty
    public String getColumnJsonType() {
        return this.columnJsonType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public boolean getIsList() {
        return this.isList;
    }

    public ColumnMetadata getColumnMetadata() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("jsonPath", this.columnJsonPath);
        properties.put("jsonType", this.columnJsonType);
        properties.put("isList", this.isList);
        properties.put("ordinalPosition", this.ordinalPosition);
        return new ColumnMetadata(this.columnName, this.columnType, "", "", false, properties);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.columnType, this.columnJsonPath, this.columnJsonType, this.ordinalPosition, this.isList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchColumnHandle other = (ElasticsearchColumnHandle)obj;
        return Objects.equals(this.getColumnName(), other.getColumnName()) && Objects.equals(this.getColumnType(), other.getColumnType()) && Objects.equals(this.getColumnJsonPath(), other.getColumnJsonPath()) && Objects.equals(this.getColumnJsonType(), other.getColumnJsonType()) && this.getOrdinalPosition() == other.getOrdinalPosition() && this.getIsList() == other.getIsList();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.getColumnName()).add("columnType", (Object)this.getColumnType()).add("columnJsonPath", (Object)this.getColumnJsonPath()).add("columnJsonType", (Object)this.getColumnJsonType()).add("ordinalPosition", this.getOrdinalPosition()).add("isList", this.getIsList()).toString();
    }
}

