/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.presto.elasticsearch.SearchGuardCertificateFormat;
import io.airlift.units.Duration;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ElasticsearchConnectorConfig {
    private String defaultSchema = "default";
    private File tableDescriptionDirectory = new File("etc/elasticsearch/");
    private int scrollSize = 1000;
    private Duration scrollTimeout = new Duration(1.0, TimeUnit.SECONDS);
    private int maxHits = 1000;
    private Duration requestTimeout = new Duration(100.0, TimeUnit.MILLISECONDS);
    private int maxRequestRetries = 5;
    private Duration maxRetryTime = new Duration(10.0, TimeUnit.SECONDS);
    private SearchGuardCertificateFormat certificateFormat = SearchGuardCertificateFormat.NONE;
    private File pemcertFilepath = new File("etc/elasticsearch/esnode.pem");
    private File pemkeyFilepath = new File("etc/elasticsearch/esnode-key.pem");
    private String pemkeyPassword = "";
    private File pemtrustedcasFilepath = new File("etc/elasticsearch/root-ca.pem");
    private File keystoreFilepath = new File("etc/elasticsearch/keystore.jks");
    private String keystorePassword = "";
    private File truststoreFilepath = new File("etc/elasticsearch/truststore.jks");
    private String truststorePassword = "";

    @NotNull
    public File getTableDescriptionDirectory() {
        return this.tableDescriptionDirectory;
    }

    @Config(value="elasticsearch.table-description-directory")
    @ConfigDescription(value="Directory that contains JSON table description files")
    public ElasticsearchConnectorConfig setTableDescriptionDirectory(File tableDescriptionDirectory) {
        this.tableDescriptionDirectory = tableDescriptionDirectory;
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="elasticsearch.default-schema-name")
    @ConfigDescription(value="Default schema name to use")
    public ElasticsearchConnectorConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) int getScrollSize() {
        return this.scrollSize;
    }

    @Config(value="elasticsearch.scroll-size")
    @ConfigDescription(value="Scroll batch size")
    public ElasticsearchConnectorConfig setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
        return this;
    }

    @NotNull
    public Duration getScrollTimeout() {
        return this.scrollTimeout;
    }

    @Config(value="elasticsearch.scroll-timeout")
    @ConfigDescription(value="Scroll timeout")
    public ElasticsearchConnectorConfig setScrollTimeout(Duration scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
        return this;
    }

    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) int getMaxHits() {
        return this.maxHits;
    }

    @Config(value="elasticsearch.max-hits")
    @ConfigDescription(value="Max number of hits a single Elasticsearch request can fetch")
    public ElasticsearchConnectorConfig setMaxHits(int maxHits) {
        this.maxHits = maxHits;
        return this;
    }

    @NotNull
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="elasticsearch.request-timeout")
    @ConfigDescription(value="Elasticsearch request timeout")
    public ElasticsearchConnectorConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxRequestRetries() {
        return this.maxRequestRetries;
    }

    @Config(value="elasticsearch.max-request-retries")
    @ConfigDescription(value="Maximum number of Elasticsearch request retries")
    public ElasticsearchConnectorConfig setMaxRequestRetries(int maxRequestRetries) {
        this.maxRequestRetries = maxRequestRetries;
        return this;
    }

    @NotNull
    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="elasticsearch.max-request-retry-time")
    @ConfigDescription(value="Use exponential backoff starting at 1s up to the value specified by this configuration when retrying failed requests")
    public ElasticsearchConnectorConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    @NotNull
    public SearchGuardCertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    @Config(value="searchguard.ssl.transport.certificate_format")
    @ConfigDescription(value="Certificate format")
    public ElasticsearchConnectorConfig setCertificateFormat(SearchGuardCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
        return this;
    }

    @NotNull
    public File getPemcertFilepath() {
        return this.pemcertFilepath;
    }

    @Config(value="searchguard.ssl.transport.pemcert_filepath")
    @ConfigDescription(value="Path to the X.509 node certificate chain")
    public ElasticsearchConnectorConfig setPemcertFilepath(File pemcertFilepath) {
        this.pemcertFilepath = pemcertFilepath;
        return this;
    }

    @NotNull
    public File getPemkeyFilepath() {
        return this.pemkeyFilepath;
    }

    @Config(value="searchguard.ssl.transport.pemkey_filepath")
    @ConfigDescription(value="Path to the certificates key file")
    public ElasticsearchConnectorConfig setPemkeyFilepath(File pemkeyFilepath) {
        this.pemkeyFilepath = pemkeyFilepath;
        return this;
    }

    @NotNull
    public String getPemkeyPassword() {
        return this.pemkeyPassword;
    }

    @Config(value="searchguard.ssl.transport.pemkey_password")
    @ConfigDescription(value="Key password. Omit this setting if the key has no password.")
    @ConfigSecuritySensitive
    public ElasticsearchConnectorConfig setPemkeyPassword(String pemkeyPassword) {
        this.pemkeyPassword = pemkeyPassword;
        return this;
    }

    @NotNull
    public File getPemtrustedcasFilepath() {
        return this.pemtrustedcasFilepath;
    }

    @Config(value="searchguard.ssl.transport.pemtrustedcas_filepath")
    @ConfigDescription(value="Path to the root CA(s) (PEM format)")
    public ElasticsearchConnectorConfig setPemtrustedcasFilepath(File pemtrustedcasFilepath) {
        this.pemtrustedcasFilepath = pemtrustedcasFilepath;
        return this;
    }

    @NotNull
    public File getKeystoreFilepath() {
        return this.keystoreFilepath;
    }

    @Config(value="searchguard.ssl.transport.keystore_filepath")
    @ConfigDescription(value="Path to the keystore file")
    public ElasticsearchConnectorConfig setKeystoreFilepath(File keystoreFilepath) {
        this.keystoreFilepath = keystoreFilepath;
        return this;
    }

    @NotNull
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Config(value="searchguard.ssl.transport.keystore_password")
    @ConfigDescription(value="Keystore password")
    @ConfigSecuritySensitive
    public ElasticsearchConnectorConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    @NotNull
    public File getTruststoreFilepath() {
        return this.truststoreFilepath;
    }

    @Config(value="searchguard.ssl.transport.truststore_filepath")
    @ConfigDescription(value="Path to the truststore file")
    public ElasticsearchConnectorConfig setTruststoreFilepath(File truststoreFilepath) {
        this.truststoreFilepath = truststoreFilepath;
        return this;
    }

    @NotNull
    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    @Config(value="searchguard.ssl.transport.truststore_password")
    @ConfigDescription(value="Truststore password")
    @ConfigSecuritySensitive
    public ElasticsearchConnectorConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }
}

