/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.decoder.DecoderModule;
import com.facebook.presto.elasticsearch.ElasticsearchClient;
import com.facebook.presto.elasticsearch.ElasticsearchConnector;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorConfig;
import com.facebook.presto.elasticsearch.ElasticsearchMetadata;
import com.facebook.presto.elasticsearch.ElasticsearchRecordSetProvider;
import com.facebook.presto.elasticsearch.ElasticsearchSplitManager;
import com.facebook.presto.elasticsearch.ElasticsearchTableDescription;
import com.facebook.presto.elasticsearch.ElasticsearchTableDescriptionProvider;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

public class ElasticsearchConnectorModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ElasticsearchConnector.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ElasticsearchConnectorConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ElasticsearchTableDescription.class);
        binder.install((Module)new DecoderModule());
    }

    @Singleton
    @Provides
    public static ElasticsearchClient createElasticsearchClient(ElasticsearchConnectorConfig config, ElasticsearchTableDescriptionProvider elasticsearchTableDescriptionProvider) throws IOException {
        return new ElasticsearchClient(elasticsearchTableDescriptionProvider, config);
    }

    private static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)value);
            return type;
        }
    }
}

