/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.ElasticsearchClient;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchTableDescription;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.ElasticsearchTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ElasticsearchMetadata
implements ConnectorMetadata {
    private final ElasticsearchClient client;

    @Inject
    public ElasticsearchMetadata(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.client.listSchemas();
    }

    public ElasticsearchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        ElasticsearchTableDescription table = this.client.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ElasticsearchTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new ElasticsearchTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        SchemaTableName tableName = new SchemaTableName(handle.getSchemaName(), handle.getTableName());
        return this.getTableMetadata(tableName).get();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.client.listTables(schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)tableHandle;
        ElasticsearchTableDescription table = this.client.getTable(handle.getSchemaName(), handle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : this.client.getColumnMetadata(table)) {
            Map properties = column.getProperties();
            int ordinalPosition = (Integer)properties.get("ordinalPosition");
            int position = ordinalPosition == -1 ? index : ordinalPosition;
            columnHandles.put((Object)column.getName(), (Object)new ElasticsearchColumnHandle(String.valueOf(properties.get("originalColumnName")), column.getType(), String.valueOf(properties.get("jsonPath")), String.valueOf(properties.get("jsonType")), position, (Boolean)properties.get("isList")));
            ++index;
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((ElasticsearchColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            Optional<ConnectorTableMetadata> tableMetadata = this.getTableMetadata(tableName);
            if (!tableMetadata.isPresent()) continue;
            columns.put((Object)tableName, (Object)tableMetadata.get().getColumns());
        }
        return columns.build();
    }

    private Optional<ConnectorTableMetadata> getTableMetadata(SchemaTableName tableName) {
        ElasticsearchTableDescription table = this.client.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableMetadata(tableName, this.client.getColumnMetadata(table)));
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, Optional.empty());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }
}

