/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.elasticsearch.ElasticsearchClient;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorConfig;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchQueryBuilder {
    private static final Logger LOG = Logger.get(ElasticsearchQueryBuilder.class);
    private final Duration scrollTimeout;
    private final int scrollSize;
    private final TransportClient client;
    private final int shard;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final List<ElasticsearchColumnHandle> columns;
    private final String index;
    private final String type;

    public ElasticsearchQueryBuilder(List<ElasticsearchColumnHandle> columnHandles, ElasticsearchConnectorConfig config, ElasticsearchSplit split) {
        InetAddress address;
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(split, "split is null");
        this.columns = columnHandles;
        this.tupleDomain = split.getTupleDomain();
        this.index = split.getIndex();
        this.shard = split.getShard();
        this.type = split.getType();
        try {
            address = InetAddress.getByName(split.getSearchNode());
        }
        catch (UnknownHostException e) {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_CONNECTION_ERROR, String.format("Error connecting to search node (%s:%d)", split.getSearchNode(), split.getPort()), (Throwable)e);
        }
        this.client = ElasticsearchClient.createTransportClient(config, new TransportAddress(address, split.getPort()));
        this.scrollTimeout = config.getScrollTimeout();
        this.scrollSize = config.getScrollSize();
    }

    public void close() {
        this.client.close();
    }

    public SearchRequestBuilder buildScrollSearchRequest() {
        String indices = this.index != null && !this.index.isEmpty() ? this.index : "_all";
        List<String> fields = this.columns.stream().map(ElasticsearchColumnHandle::getColumnName).collect(Collectors.toList());
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{indices}).setTypes(new String[]{this.type}).setSearchType(SearchType.QUERY_THEN_FETCH).setScroll(new TimeValue(this.scrollTimeout.toMillis())).setFetchSource(fields.toArray(new String[0]), null).setQuery(this.buildSearchQuery()).setPreference("_shards:" + this.shard).addSort("_doc", SortOrder.ASC).setSize(this.scrollSize);
        LOG.debug("Elasticsearch Request: %s", new Object[]{searchRequestBuilder});
        return searchRequestBuilder;
    }

    public SearchScrollRequestBuilder prepareSearchScroll(String scrollId) {
        return this.client.prepareSearchScroll(scrollId).setScroll(new TimeValue(this.scrollTimeout.toMillis()));
    }

    private QueryBuilder buildSearchQuery() {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        for (ElasticsearchColumnHandle column : this.columns) {
            Domain domain;
            BoolQueryBuilder columnQueryBuilder = new BoolQueryBuilder();
            Type type = column.getColumnType();
            if (this.tupleDomain.getDomains().isPresent() && (domain = (Domain)((Map)this.tupleDomain.getDomains().get()).get(column)) != null) {
                columnQueryBuilder.should(this.buildPredicate(column.getColumnJsonPath(), domain, type));
            }
            boolQueryBuilder.must((QueryBuilder)columnQueryBuilder);
        }
        if (boolQueryBuilder.hasClauses()) {
            return boolQueryBuilder;
        }
        return new MatchAllQueryBuilder();
    }

    private QueryBuilder buildPredicate(String columnName, Domain domain, Type type) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        if (domain.getValues().isNone()) {
            boolQueryBuilder.mustNot((QueryBuilder)new ExistsQueryBuilder(columnName));
            return boolQueryBuilder;
        }
        if (domain.getValues().isAll()) {
            boolQueryBuilder.must((QueryBuilder)new ExistsQueryBuilder(columnName));
            return boolQueryBuilder;
        }
        return this.buildTermQuery(boolQueryBuilder, columnName, domain, type);
    }

    private QueryBuilder buildTermQuery(BoolQueryBuilder queryBuilder, String columnName, Domain domain, Type type) {
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            BoolQueryBuilder rangeQueryBuilder = new BoolQueryBuilder();
            HashSet<Object> valuesToInclude = new HashSet<Object>();
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0, (Object)("Invalid range for column: " + columnName));
            if (range.isSingleValue()) {
                valuesToInclude.add(range.getLow().getValue());
            } else {
                if (!range.getLow().isLowerUnbounded()) {
                    switch (range.getLow().getBound()) {
                        case ABOVE: {
                            rangeQueryBuilder.must((QueryBuilder)new RangeQueryBuilder(columnName).gt(ElasticsearchQueryBuilder.getValue(type, range.getLow().getValue())));
                            break;
                        }
                        case EXACTLY: {
                            rangeQueryBuilder.must((QueryBuilder)new RangeQueryBuilder(columnName).gte(ElasticsearchQueryBuilder.getValue(type, range.getLow().getValue())));
                            break;
                        }
                        case BELOW: {
                            throw new IllegalArgumentException("Low marker should never use BELOW bound");
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                        }
                    }
                }
                if (!range.getHigh().isUpperUnbounded()) {
                    switch (range.getHigh().getBound()) {
                        case EXACTLY: {
                            rangeQueryBuilder.must((QueryBuilder)new RangeQueryBuilder(columnName).lte(ElasticsearchQueryBuilder.getValue(type, range.getHigh().getValue())));
                            break;
                        }
                        case BELOW: {
                            rangeQueryBuilder.must((QueryBuilder)new RangeQueryBuilder(columnName).lt(ElasticsearchQueryBuilder.getValue(type, range.getHigh().getValue())));
                            break;
                        }
                        case ABOVE: {
                            throw new IllegalArgumentException("High marker should never use ABOVE bound");
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                        }
                    }
                }
            }
            if (valuesToInclude.size() == 1) {
                rangeQueryBuilder.must((QueryBuilder)new TermQueryBuilder(columnName, ElasticsearchQueryBuilder.getValue(type, Iterables.getOnlyElement(valuesToInclude))));
            }
            queryBuilder.should((QueryBuilder)rangeQueryBuilder);
        }
        return queryBuilder;
    }

    private static Object getValue(Type type, Object value) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(DoubleType.DOUBLE) || type.equals(BooleanType.BOOLEAN)) {
            return value;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return ((Slice)value).toStringUtf8();
        }
        throw new IllegalArgumentException("Unhandled type: " + type);
    }
}

