/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorConfig;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.ElasticsearchQueryBuilder;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.elasticsearch.ElasticsearchUtils;
import com.facebook.presto.elasticsearch.RetryDriver;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;

public class ElasticsearchRecordCursor
implements RecordCursor {
    private static final JsonCodec<Object> VALUE_CODEC = JsonCodec.jsonCodec(Object.class);
    private final List<ElasticsearchColumnHandle> columnHandles;
    private final Map<String, Integer> jsonPathToIndex = new HashMap<String, Integer>();
    private final int maxHits;
    private final Iterator<SearchHit> searchHits;
    private final Duration requestTimeout;
    private final int maxAttempts;
    private final Duration maxRetryTime;
    private final ElasticsearchQueryBuilder builder;
    private long totalBytes;
    private List<Object> fields;

    public ElasticsearchRecordCursor(List<ElasticsearchColumnHandle> columnHandles, ElasticsearchConnectorConfig config, ElasticsearchSplit split) {
        Objects.requireNonNull(columnHandles, "columnHandle is null");
        Objects.requireNonNull(config, "config is null");
        this.columnHandles = columnHandles;
        this.maxHits = config.getMaxHits();
        this.requestTimeout = config.getRequestTimeout();
        this.maxAttempts = config.getMaxRequestRetries();
        this.maxRetryTime = config.getMaxRetryTime();
        for (int i = 0; i < columnHandles.size(); ++i) {
            this.jsonPathToIndex.put(columnHandles.get(i).getColumnJsonPath(), i);
        }
        this.builder = new ElasticsearchQueryBuilder(columnHandles, config, split);
        this.searchHits = this.sendElasticsearchQuery(this.builder).iterator();
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getColumnType();
    }

    public boolean advanceNextPosition() {
        if (!this.searchHits.hasNext()) {
            return false;
        }
        SearchHit hit = this.searchHits.next();
        this.fields = new ArrayList<Object>(Collections.nCopies(this.columnHandles.size(), null));
        this.setFieldIfExists("_id", hit.getId());
        this.setFieldIfExists("_index", hit.getIndex());
        this.extractFromSource(hit);
        if (hit.getSourceRef() != null) {
            this.totalBytes += (long)hit.getSourceRef().length();
        }
        return true;
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, (Set<Type>)ImmutableSet.of((Object)BooleanType.BOOLEAN));
        return Boolean.parseBoolean(this.getFieldValue(field).toString());
    }

    public long getLong(int field) {
        this.checkFieldType(field, (Set<Type>)ImmutableSet.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER));
        return Long.parseLong(this.getFieldValue(field).toString());
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Set<Type>)ImmutableSet.of((Object)DoubleType.DOUBLE));
        return Double.parseDouble(this.getFieldValue(field).toString());
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, (Set<Type>)ImmutableSet.of((Object)VarcharType.VARCHAR));
        Object value = this.getFieldValue(field);
        if (value instanceof Collection) {
            return Slices.utf8Slice((String)VALUE_CODEC.toJson(value));
        }
        if (value == null) {
            return Slices.EMPTY_SLICE;
        }
        return Slices.utf8Slice((String)value.toString());
    }

    public Object getObject(int field) {
        return ElasticsearchUtils.serializeObject(this.columnHandles.get(field).getColumnType(), null, this.getFieldValue(field));
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.getFieldValue(field) == null;
    }

    private void checkFieldType(int field, Set<Type> expectedTypes) {
        Preconditions.checkArgument((boolean)expectedTypes.contains(this.getType(field)), (String)"Field %s has unexpected type %s", (int)field, (Object)this.getType(field));
    }

    public void close() {
        this.builder.close();
    }

    private SearchResponse getSearchResponse(ElasticsearchQueryBuilder queryBuilder) {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(this.maxRetryTime).run("searchRequest", () -> (SearchResponse)queryBuilder.buildScrollSearchRequest().execute().actionGet(this.requestTimeout.toMillis()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SearchResponse getScrollResponse(ElasticsearchQueryBuilder queryBuilder, String scrollId) {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(this.maxRetryTime).run("scrollRequest", () -> (SearchResponse)queryBuilder.prepareSearchScroll(scrollId).execute().actionGet(this.requestTimeout.toMillis()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<SearchHit> sendElasticsearchQuery(ElasticsearchQueryBuilder queryBuilder) {
        SearchResponse response = this.getSearchResponse(queryBuilder);
        if (response.getHits().getTotalHits() > (long)this.maxHits) {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_MAX_HITS_EXCEEDED, String.format("The number of hits for the query (%d) exceeds the configured max hits (%d)", response.getHits().getTotalHits(), this.maxHits));
        }
        ImmutableList.Builder result = ImmutableList.builder();
        do {
            for (SearchHit hit : response.getHits().getHits()) {
                result.add((Object)hit);
            }
        } while ((response = this.getScrollResponse(queryBuilder, response.getScrollId())).getHits().getHits().length != 0);
        return result.build();
    }

    private void setFieldIfExists(String jsonPath, Object jsonValue) {
        if (this.jsonPathToIndex.containsKey(jsonPath)) {
            this.fields.set(this.jsonPathToIndex.get(jsonPath), jsonValue);
        }
    }

    private Object getFieldValue(int field) {
        Preconditions.checkState((this.fields != null ? 1 : 0) != 0, (Object)"Cursor has not been advanced yet");
        return this.fields.get(field);
    }

    private void extractFromSource(SearchHit hit) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Map.Entry entry : hit.getSourceAsMap().entrySet()) {
            fields.add(new Field((String)entry.getKey(), entry.getValue()));
        }
        Collections.sort(fields, Comparator.comparing(Field::getName));
        for (Map.Entry<Object, Object> entry : ElasticsearchRecordCursor.unflatten(fields).entrySet()) {
            this.setFieldIfExists((String)entry.getKey(), entry.getValue());
        }
    }

    private static Map<String, Object> unflatten(List<Field> fields) {
        return ElasticsearchRecordCursor.unflatten(fields, 0, 0, fields.size());
    }

    private static Map<String, Object> unflatten(List<Field> fields, int level, int start, int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be > 0");
        int limit = start + length;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int anchor = start;
        int current = start;
        do {
            Field field = fields.get(anchor);
            String name = field.getPathElement(level);
            if (++current != limit && name.equals(fields.get(current).getPathElement(level))) continue;
            Map<String, Object> value = level < field.getDepth() - 1 ? ElasticsearchRecordCursor.unflatten(fields, level + 1, anchor, current - anchor) : field.getValue();
            result.put(name, value);
            anchor = current;
        } while (current < limit);
        return result;
    }

    private static final class Field {
        private final String name;
        private final List<String> path;
        private final Object value;

        public Field(String name, Object value) {
            this.name = name;
            this.path = Arrays.asList(name.split("\\."));
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getDepth() {
            return this.path.size();
        }

        public String getPathElement(int level) {
            return this.path.get(level);
        }

        public Object getValue() {
            return this.value;
        }
    }
}

