/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchConnectorConfig;
import com.facebook.presto.elasticsearch.ElasticsearchRecordCursor;
import com.facebook.presto.elasticsearch.ElasticsearchSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ElasticsearchRecordSet
implements RecordSet {
    private final List<ElasticsearchColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final ElasticsearchSplit split;
    private final ElasticsearchConnectorConfig config;

    public ElasticsearchRecordSet(ElasticsearchSplit split, ElasticsearchConnectorConfig config, List<ElasticsearchColumnHandle> columnHandles) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.config = Objects.requireNonNull(config, "config is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnTypes = (List)columnHandles.stream().map(ElasticsearchColumnHandle::getColumnType).collect(ImmutableList.toImmutableList());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new ElasticsearchRecordCursor(this.columnHandles, this.config, this.split);
    }
}

